/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.currency;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.yapbam.remote.RemoteData;

public class CurrencyData
implements RemoteData {
    private static final String CURRENCY_IS_NOT_AVAILABLE = "{0} currency is not available.";
    private long timeStamp = -1L;
    private Map<String, Long> rates = new HashMap<String, Long>();
    private boolean locked;

    public void setReferenceDate(long date) {
        if (this.locked) {
            throw new UnsupportedOperationException();
        }
        this.timeStamp = date;
    }

    public void setCurrencyRate(String isoCode, long rate) {
        this.rates.put(isoCode, rate);
    }

    public void lock() {
        this.rates = Collections.unmodifiableMap(this.rates);
        this.locked = true;
    }

    private boolean checkCurrencyArgs(String fromCurrency, String toCurrency) {
        if (!this.rates.containsKey(fromCurrency)) {
            throw new IllegalArgumentException(MessageFormat.format(CURRENCY_IS_NOT_AVAILABLE, fromCurrency));
        }
        if (!this.rates.containsKey(toCurrency)) {
            throw new IllegalArgumentException(MessageFormat.format(CURRENCY_IS_NOT_AVAILABLE, toCurrency));
        }
        return !fromCurrency.equals(toCurrency);
    }

    public double convert(double amount, String fromCurrency, String toCurrency) {
        if (this.checkCurrencyArgs(fromCurrency, toCurrency)) {
            amount *= (double)this.rates.get(toCurrency).longValue();
            amount /= (double)this.rates.get(fromCurrency).longValue();
        }
        return amount;
    }

    public long convert(long amount, String fromCurrency, String toCurrency) {
        if (this.checkCurrencyArgs(fromCurrency, toCurrency)) {
            amount *= this.rates.get(toCurrency).longValue();
            amount /= this.rates.get(fromCurrency).longValue();
        }
        return amount;
    }

    public boolean isAvailable(String currency) {
        return this.rates.containsKey(currency);
    }

    public String[] getCurrencies() {
        return this.rates.keySet().toArray(new String[this.rates.size()]);
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }
}

