/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.yapbam.data.Alert;
import net.yapbam.data.AlertThreshold;
import net.yapbam.data.BalanceData;
import net.yapbam.data.BalanceHistory;
import net.yapbam.data.Checkbook;
import net.yapbam.data.Mode;
import net.yapbam.data.Transaction;

public class Account {
    private String name;
    private double initialBalance;
    private List<Mode> modes;
    private List<Checkbook> checkbooks;
    private int transactionNumber;
    private int unCheckedTransactionNumber;
    private BalanceData balanceData;
    private AlertThreshold alertThreshold;
    private String comment;

    public Account(String name, double initialBalance) {
        this(name, initialBalance, AlertThreshold.DEFAULT);
    }

    public Account(String name, double initialBalance, AlertThreshold alerts) {
        this(name, initialBalance, alerts, null);
    }

    public Account(String name, double initialBalance, AlertThreshold alerts, String comment) {
        this.name = name;
        this.initialBalance = initialBalance;
        this.alertThreshold = alerts;
        this.modes = new ArrayList<Mode>();
        this.checkbooks = new ArrayList<Checkbook>();
        this.balanceData = new BalanceData();
        this.balanceData.clear(initialBalance);
        this.add(Mode.UNDEFINED);
        this.setComment(comment);
    }

    public String getName() {
        return this.name;
    }

    public double getInitialBalance() {
        return this.initialBalance;
    }

    public Mode getMode(String name) {
        for (int i = 0; i < this.modes.size(); ++i) {
            if (!this.modes.get(i).getName().equalsIgnoreCase(name)) continue;
            return this.modes.get(i);
        }
        return null;
    }

    public int getCheckbooksNumber() {
        return this.checkbooks.size();
    }

    public Checkbook getCheckbook(int index) {
        return this.checkbooks.get(index);
    }

    public int indexOf(Checkbook book) {
        return this.checkbooks.indexOf(book);
    }

    void add(Checkbook book) {
        this.checkbooks.add(book);
    }

    void remove(Checkbook book) {
        this.checkbooks.remove(book);
    }

    public int getTransactionsNumber() {
        return this.transactionNumber;
    }

    public int getUncheckedTransactionsNumber() {
        return this.unCheckedTransactionNumber;
    }

    void add(Transaction[] transactions) {
        this.transactionNumber += transactions.length;
        for (Transaction transaction : transactions) {
            if (transaction.isChecked()) continue;
            ++this.unCheckedTransactionNumber;
        }
        this.balanceData.updateBalance(transactions, true);
    }

    void remove(Transaction[] transactions) {
        this.transactionNumber -= transactions.length;
        for (Transaction transaction : transactions) {
            if (transaction.isChecked()) continue;
            --this.unCheckedTransactionNumber;
        }
        this.balanceData.updateBalance(transactions, false);
    }

    void add(Mode newMode) {
        if (this.getMode(newMode.getName()) != null) {
            throw new IllegalArgumentException("This account already contains the mode " + newMode.getName());
        }
        this.modes.add(newMode);
    }

    void remove(Mode mode) {
        this.modes.remove(mode);
    }

    void replace(Mode oldMode, Mode newMode) {
        oldMode.updateTo(newMode);
    }

    public String toString() {
        return MessageFormat.format("{0}[{1,number,currency}]", this.getName(), this.initialBalance);
    }

    public int getModesNumber() {
        return this.modes.size();
    }

    public Mode getMode(int index) {
        return this.modes.get(index);
    }

    public int indexOf(Mode mode) {
        return this.modes.indexOf(mode);
    }

    void setName(String name) {
        this.name = name;
    }

    void setInitialBalance(double value) {
        this.balanceData.updateBalance(this.initialBalance, false);
        this.initialBalance = value;
        this.balanceData.updateBalance(this.initialBalance, true);
    }

    public AlertThreshold getAlertThreshold() {
        return this.alertThreshold;
    }

    void setAlertThreshold(AlertThreshold alertThreshold) {
        this.alertThreshold = alertThreshold;
    }

    public BalanceData getBalanceData() {
        return this.balanceData;
    }

    public String getComment() {
        return this.comment;
    }

    void setComment(String comment) {
        this.comment = comment;
        if (this.comment != null) {
            this.comment = this.comment.trim();
            if (this.comment.length() == 0) {
                this.comment = null;
            }
        }
    }

    public Alert getFirstAlert(Date from, Date to) {
        BalanceHistory balanceHistory = this.getBalanceData().getBalanceHistory();
        long firstAlertDate = balanceHistory.getFirstAlertDate(from, to, this.getAlertThreshold());
        if (firstAlertDate >= 0L) {
            Date date = new Date();
            if (firstAlertDate > 0L) {
                date.setTime(firstAlertDate);
            }
            return new Alert(date, this, balanceHistory.getBalance(date));
        }
        return null;
    }
}

