/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.yapbam.data.Account;
import net.yapbam.data.Category;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Mode;
import net.yapbam.data.SubTransaction;
import net.yapbam.data.Transaction;
import net.yapbam.util.NullUtils;

public abstract class Archiver {
    protected Archiver() {
    }

    public final boolean move(GlobalData data, GlobalData archive, Transaction[] transactions, boolean toArchive) {
        Archiver.copy(data, archive, transactions, toArchive);
        if (this.save(toArchive ? archive : data)) {
            Archiver.remove(data, archive, transactions, toArchive);
            if (!toArchive) {
                return this.save(archive);
            }
            return true;
        }
        return false;
    }

    protected abstract boolean save(GlobalData var1);

    private static void copy(GlobalData data, GlobalData archive, Transaction[] transactions, boolean toArchive) {
        if (data.isArchive() || !archive.isArchive()) {
            throw new IllegalArgumentException();
        }
        GlobalData target = toArchive ? archive : data;
        target.setEventsEnabled(false);
        Archiver.copy(target, transactions, toArchive);
        if (!toArchive) {
            Map<Account, Double> accountToAmount = Archiver.getAmounts(transactions);
            target.setEventsEnabled(false);
            for (Map.Entry<Account, Double> entry : accountToAmount.entrySet()) {
                Account account = target.getAccount(entry.getKey().getName());
                double initialBalance = account.getInitialBalance() - entry.getValue();
                target.setInitialBalance(account, initialBalance);
            }
        }
        target.setEventsEnabled(true);
    }

    private static void remove(GlobalData data, GlobalData archive, Transaction[] transactions, boolean toArchive) {
        GlobalData source = toArchive ? data : archive;
        source.setEventsEnabled(false);
        source.remove(transactions);
        if (toArchive) {
            Map<Account, Double> accountToAmount = Archiver.getAmounts(transactions);
            for (Map.Entry<Account, Double> entry : accountToAmount.entrySet()) {
                Account account = entry.getKey();
                Double initialBalance = entry.getValue() + account.getInitialBalance();
                source.setInitialBalance(account, initialBalance);
            }
        } else {
            for (int i = archive.getAccountsNumber() - 1; i >= 0; --i) {
                Account account = archive.getAccount(i);
                if (account.getTransactionsNumber() != 0) continue;
                archive.remove(account);
            }
        }
        source.setEventsEnabled(true);
    }

    private static void copy(GlobalData data, Transaction[] transactions, boolean toArchive) {
        Transaction[] copies = new Transaction[transactions.length];
        for (int i = 0; i < copies.length; ++i) {
            copies[i] = Archiver.getTransaction(data, transactions[i], toArchive);
        }
        data.add(copies);
    }

    private static Transaction getTransaction(GlobalData data, Transaction transaction, boolean toArchive) {
        Account account = Archiver.getAccount(data, transaction.getAccount());
        Mode mode = Archiver.getMode(data, account, transaction.getMode(), toArchive);
        Category category = Archiver.getCategory(data, transaction.getCategory());
        return new Transaction(transaction.getDate(), transaction.getNumber(), transaction.getDescription(), transaction.getComment(), transaction.getAmount(), account, mode, category, transaction.getValueDate(), transaction.getStatement(), Archiver.getSubTransactions(data, transaction));
    }

    private static Account getAccount(GlobalData data, Account account) {
        Account currentAccount = data.getAccount(account.getName());
        if (currentAccount == null) {
            currentAccount = new Account(account.getName(), account.getInitialBalance());
            data.add(currentAccount);
        }
        return currentAccount;
    }

    private static Mode getMode(GlobalData data, Account account, Mode mode, boolean toArchive) {
        Mode currentMode = account.getMode(mode.getName());
        if (currentMode == null) {
            currentMode = new Mode(mode.getName(), mode.getReceiptVdc(), mode.getExpenseVdc(), mode.isUseCheckBook());
            account.add(currentMode);
        } else if (toArchive && !NullUtils.areEquals(mode.getReceiptVdc(), currentMode.getReceiptVdc()) || !NullUtils.areEquals(mode.getExpenseVdc(), currentMode.getExpenseVdc()) || mode.isUseCheckBook() != currentMode.isUseCheckBook()) {
            Mode oldMode = currentMode;
            currentMode = new Mode(mode.getName(), mode.getReceiptVdc(), mode.getExpenseVdc(), mode.isUseCheckBook());
            data.setMode(account, oldMode, currentMode);
        }
        return currentMode;
    }

    private static Category getCategory(GlobalData data, Category category) {
        Category currentCategory = data.getCategory(category.getName());
        if (currentCategory == null) {
            currentCategory = new Category(category.getName());
            data.add(currentCategory);
        }
        return currentCategory;
    }

    private static List<SubTransaction> getSubTransactions(GlobalData data, Transaction transaction) {
        ArrayList<SubTransaction> result = new ArrayList<SubTransaction>(transaction.getSubTransactionSize());
        for (int i = 0; i < transaction.getSubTransactionSize(); ++i) {
            SubTransaction sb = transaction.getSubTransaction(i);
            result.add(new SubTransaction(sb.getAmount(), sb.getDescription(), Archiver.getCategory(data, sb.getCategory())));
        }
        return result;
    }

    private static Map<Account, Double> getAmounts(Transaction[] transactions) {
        HashMap<Account, Double> accountToAmount = new HashMap<Account, Double>();
        for (Transaction transaction : transactions) {
            Account account = transaction.getAccount();
            Double amount = (Double)accountToAmount.get(account);
            if (amount == null) {
                amount = 0.0;
            }
            amount = amount + transaction.getAmount();
            accountToAmount.put(account, amount);
        }
        return accountToAmount;
    }
}

