/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.yapbam.data.AlertThreshold;
import net.yapbam.data.BalanceHistoryElement;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Transaction;
import net.yapbam.data.TransactionComparator;
import net.yapbam.util.DateUtils;
import net.yapbam.util.NullUtils;

public class BalanceHistory {
    private static final Comparator<Object> COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof BalanceHistoryElement) {
                return -((BalanceHistoryElement)o1).getRelativePosition((Date)o2);
            }
            return ((BalanceHistoryElement)o2).getRelativePosition((Date)o1);
        }
    };
    private boolean minMaxCached = false;
    private Date minMaxEndDate;
    private double minBalance;
    private double maxBalance;
    private List<BalanceHistoryElement> elements = new ArrayList<BalanceHistoryElement>();
    private List<Transaction> transactions;

    public BalanceHistory(double intialBalance) {
        this.elements.add(new BalanceHistoryElement(intialBalance, null, null));
        this.transactions = new ArrayList<Transaction>();
    }

    public double getMinBalance() {
        return this.getMinBalance(null);
    }

    public double getMinBalance(Date endDate) {
        this.refreshMinMax(endDate);
        return this.minBalance;
    }

    public long getFirstAlertDate(Date from, Date to, AlertThreshold alert) {
        if (alert.isLifeless()) {
            return -1L;
        }
        int firstIndex = from == null ? 0 : this.find(from);
        int lastIndex = to == null ? this.elements.size() - 1 : this.find(to);
        for (int i = firstIndex; i <= lastIndex; ++i) {
            BalanceHistoryElement element = this.elements.get(i);
            if (alert.getTrigger(element.getBalance()) == 0) continue;
            Date result = element.getFrom();
            return result == null ? 0L : result.getTime();
        }
        return -1L;
    }

    public double getMaxBalance() {
        return this.getMaxBalance(null);
    }

    public double getMaxBalance(Date endDate) {
        this.refreshMinMax(endDate);
        return this.maxBalance;
    }

    private void refreshMinMax(Date endDate) {
        if (!this.minMaxCached || !NullUtils.areEquals(endDate, this.minMaxEndDate)) {
            this.minBalance = this.maxBalance = this.get(0).getBalance();
            for (BalanceHistoryElement element : this.elements) {
                if (endDate != null && element.getRelativePosition(endDate) < 0) break;
                double balance = element.getBalance();
                if (this.maxBalance < balance) {
                    this.maxBalance = balance;
                    continue;
                }
                if (!(this.minBalance > balance)) continue;
                this.minBalance = balance;
            }
            this.minMaxEndDate = endDate;
            this.minMaxCached = true;
        }
    }

    public int size() {
        return this.elements.size();
    }

    public BalanceHistoryElement get(int index) {
        return this.elements.get(index);
    }

    public int find(Date date) {
        return Collections.binarySearch(this.elements, date, COMPARATOR);
    }

    public double getBalance(Date date) {
        return this.get(this.find(date)).getBalance();
    }

    void add(double amount, Date date) {
        if (date == null) {
            if (this.minMaxCached) {
                this.minBalance += amount;
                this.maxBalance += amount;
            }
            Iterator<BalanceHistoryElement> iterator = this.elements.iterator();
            while (iterator.hasNext()) {
                iterator.next().add(amount);
            }
        } else {
            int index = this.find(date);
            BalanceHistoryElement element = this.get(index);
            if (!date.equals(element.getFrom())) {
                BalanceHistoryElement el2 = new BalanceHistoryElement(element.getBalance(), date, element.getTo());
                element.setTo(date);
                this.elements.add(++index, el2);
            } else {
                BalanceHistoryElement previous = this.elements.get(index - 1);
                double future = element.getBalance() + amount;
                if (GlobalData.AMOUNT_COMPARATOR.compare(previous.getBalance(), future) == 0) {
                    this.elements.remove(index);
                    previous.setTo(element.getTo());
                }
            }
            for (int i = index; i < this.elements.size(); ++i) {
                element = this.elements.get(i);
                element.add(amount);
            }
            this.minMaxCached = false;
        }
    }

    void add(Transaction transaction) {
        this.add(transaction.getAmount(), transaction.getValueDate());
        int index = -Collections.binarySearch(this.transactions, transaction, TransactionComparator.VALUE_DATE_COMPARATOR) - 1;
        this.transactions.add(index, transaction);
    }

    void remove(Transaction transaction) {
        this.add(-transaction.getAmount(), transaction.getValueDate());
        int index = Collections.binarySearch(this.transactions, transaction, TransactionComparator.VALUE_DATE_COMPARATOR);
        if (index >= 0) {
            this.transactions.remove(index);
        }
    }

    public int getTransactionsNumber() {
        return this.transactions.size();
    }

    public Transaction getTransaction(int index) {
        return this.transactions.get(index);
    }

    public int find(Transaction transaction) {
        return this.transactions.indexOf(transaction);
    }

    private int getFirstIndexOf(int valueDate) {
        if (this.transactions.isEmpty()) {
            return -1;
        }
        int first = 0;
        int last = this.transactions.size() - 1;
        while (first != last) {
            if (valueDate < this.transactions.get(first).getValueDateAsInteger() || valueDate > this.transactions.get(last).getValueDateAsInteger()) {
                return -1;
            }
            if (last - first == 1) {
                if (valueDate == this.transactions.get(first).getValueDateAsInteger()) {
                    return first;
                }
                if (valueDate == this.transactions.get(last).getValueDateAsInteger()) {
                    return last;
                }
                return -1;
            }
            int middle = (first + last) / 2;
            if (valueDate <= this.transactions.get(middle).getValueDateAsInteger()) {
                last = middle;
                continue;
            }
            first = middle;
        }
        return first;
    }

    public List<Transaction> getTransactions(int index) {
        Transaction t;
        BalanceHistoryElement element = this.get(index);
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        Date from = element.getFrom();
        int first = from == null ? 0 : this.getFirstIndexOf(DateUtils.dateToInteger(from));
        Date to = element.getTo();
        int lastDate = to == null ? Integer.MAX_VALUE : DateUtils.dateToInteger(to);
        for (int i = first; i < this.transactions.size() && (t = this.getTransaction(i)).getValueDateAsInteger() < lastDate; ++i) {
            result.add(t);
        }
        return result;
    }
}

