/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data;

import java.math.BigInteger;
import java.text.MessageFormat;

public class Checkbook {
    private String prefix;
    private BigInteger firstNumber;
    private int size;
    private int used;
    private int numberLength;

    public Checkbook(String prefix, BigInteger start, int size, BigInteger next) {
        this.firstNumber = start;
        this.prefix = prefix;
        this.size = size;
        this.numberLength = start.add(BigInteger.valueOf(size)).toString().length();
        if (next != null) {
            this.used = next.subtract(start).intValue();
            if (this.used >= size) {
                throw new IllegalArgumentException();
            }
        } else {
            this.used = size;
        }
    }

    public BigInteger getNext() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getFirst().add(BigInteger.valueOf(this.used));
    }

    public BigInteger get(int index) {
        if (index >= this.size) {
            return null;
        }
        return this.getFirst().add(BigInteger.valueOf(index));
    }

    public String getFullNumber(BigInteger shortNumber) {
        if (shortNumber == null) {
            return null;
        }
        String number = this.prefix + shortNumber.toString();
        StringBuilder leadingZeros = new StringBuilder();
        for (int i = number.length(); i < this.numberLength; ++i) {
            leadingZeros.append('0');
        }
        number = leadingZeros + number;
        return number;
    }

    public boolean isEmpty() {
        return this.used >= this.size;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public BigInteger getFirst() {
        return this.firstNumber;
    }

    public BigInteger getLast() {
        return this.firstNumber.add(BigInteger.valueOf((long)this.size - 1L));
    }

    public int size() {
        return this.size;
    }

    public int getUsed() {
        return this.used;
    }

    public int getRemaining() {
        return Math.max(0, this.size - this.used);
    }

    public String toString() {
        return MessageFormat.format("{0}[{1}-{2}]->{3}", this.prefix, this.getFullNumber(this.getNext()), this.getFullNumber(this.getLast()), this.getFullNumber(this.getNext()));
    }

    void copy(Checkbook checkbook) {
        this.firstNumber = checkbook.firstNumber;
        this.numberLength = checkbook.numberLength;
        this.prefix = checkbook.prefix;
        this.size = checkbook.size;
        this.used = checkbook.used;
    }

    public BigInteger getNumber(String fullNumber) {
        if (!fullNumber.startsWith(this.prefix)) {
            return null;
        }
        String numberString = fullNumber.substring(this.prefix.length());
        try {
            BigInteger result = new BigInteger(numberString);
            if (result.compareTo(this.firstNumber) < 0 || result.compareTo(this.getFirst().add(BigInteger.valueOf(this.size))) >= 0) {
                return null;
            }
            return result;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

