/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data;

import net.yapbam.date.helpers.DateStepper;
import net.yapbam.util.NullUtils;

public class Mode {
    public static final Mode UNDEFINED = new Mode("", DateStepper.IMMEDIATE, DateStepper.IMMEDIATE, false);
    private String name;
    private DateStepper receiptVDC;
    private DateStepper expenseVDC;
    private boolean useCheckBook;

    public Mode(String name, DateStepper receiptVDC, DateStepper expenseVDC, boolean useCheckbook) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (useCheckbook && expenseVDC == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.receiptVDC = receiptVDC;
        this.expenseVDC = expenseVDC;
        this.useCheckBook = useCheckbook;
    }

    public String getName() {
        return this.name;
    }

    public DateStepper getReceiptVdc() {
        return this.receiptVDC;
    }

    public DateStepper getExpenseVdc() {
        return this.expenseVDC;
    }

    public boolean isUseCheckBook() {
        return this.useCheckBook;
    }

    public boolean isUsableForReceipt() {
        return this.receiptVDC != null;
    }

    public boolean isUsableForExpense() {
        return this.expenseVDC != null;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Mode)) {
            return false;
        }
        return NullUtils.areEquals(this.getName(), ((Mode)obj).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName() + "[" + this.getExpenseVdc() + "/" + this.getReceiptVdc() + "-" + (this.isUseCheckBook() ? "check" : "no check") + "]";
    }

    void updateTo(Mode newMode) {
        this.name = newMode.name;
        this.expenseVDC = newMode.expenseVDC;
        this.receiptVDC = newMode.receiptVDC;
        this.useCheckBook = newMode.useCheckBook;
    }
}

