/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data;

import java.util.Arrays;
import java.util.Observable;
import net.yapbam.data.FilteredData;
import net.yapbam.data.Transaction;
import net.yapbam.data.event.AccountAddedEvent;
import net.yapbam.data.event.AccountPropertyChangedEvent;
import net.yapbam.data.event.AccountRemovedEvent;
import net.yapbam.data.event.CheckbookAddedEvent;
import net.yapbam.data.event.CheckbookPropertyChangedEvent;
import net.yapbam.data.event.CheckbookRemovedEvent;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.data.event.ModeAddedEvent;
import net.yapbam.data.event.ModePropertyChangedEvent;
import net.yapbam.data.event.ModeRemovedEvent;
import net.yapbam.data.event.NeedToBeSavedChangedEvent;
import net.yapbam.data.event.PasswordChangedEvent;
import net.yapbam.data.event.PeriodicalTransactionsAddedEvent;
import net.yapbam.data.event.PeriodicalTransactionsRemovedEvent;
import net.yapbam.data.event.TransactionsAddedEvent;
import net.yapbam.data.event.TransactionsRemovedEvent;
import net.yapbam.data.event.URIChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatData
extends Observable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatData.class);
    private int nbReceipts;
    private int nbExpenses;
    private double receipts;
    private double expenses;
    private FilteredData data;
    private boolean needRefresh;

    public StatData(FilteredData data) {
        this.data = data;
        this.nbReceipts = 0;
        this.nbExpenses = 0;
        this.receipts = 0.0;
        this.expenses = 0.0;
        this.needRefresh = false;
        data.addListener(new DataListener(){

            @Override
            public void processEvent(DataEvent event) {
                if (!StatData.this.isNeutral(event)) {
                    if (!StatData.this.needRefresh && event instanceof TransactionsAddedEvent) {
                        Transaction[] transactions = ((TransactionsAddedEvent)event).getTransactions();
                        StatData.this.refresh(Arrays.asList(transactions), true);
                        LOGGER.trace("Partial update done on {} transactions", (Object)transactions.length);
                    } else if (!StatData.this.needRefresh && event instanceof TransactionsRemovedEvent) {
                        Transaction[] transactions = ((TransactionsRemovedEvent)event).getTransactions();
                        StatData.this.refresh(Arrays.asList(transactions), false);
                        LOGGER.trace("Partial update done on {} transactions", (Object)transactions.length);
                    } else {
                        StatData.this.needRefresh = true;
                    }
                    StatData.this.fireChanged();
                }
            }
        });
    }

    private boolean isNeutral(DataEvent event) {
        return event instanceof NeedToBeSavedChangedEvent || event instanceof PasswordChangedEvent || event instanceof URIChangedEvent || event instanceof AccountAddedEvent || event instanceof AccountRemovedEvent || event instanceof AccountPropertyChangedEvent || event instanceof ModeAddedEvent || event instanceof ModeRemovedEvent || event instanceof ModePropertyChangedEvent || event instanceof CheckbookPropertyChangedEvent || event instanceof CheckbookAddedEvent || event instanceof CheckbookRemovedEvent || event instanceof PeriodicalTransactionsAddedEvent || event instanceof PeriodicalTransactionsRemovedEvent;
    }

    private void ensureIsUpdated() {
        if (this.needRefresh) {
            this.refresh();
        }
    }

    public int getNbReceipts() {
        this.ensureIsUpdated();
        return this.nbReceipts;
    }

    public int getNbExpenses() {
        this.ensureIsUpdated();
        return this.nbExpenses;
    }

    public double getReceipts() {
        this.ensureIsUpdated();
        return this.receipts;
    }

    public double getExpenses() {
        this.ensureIsUpdated();
        return this.expenses;
    }

    private void refresh() {
        this.nbReceipts = 0;
        this.receipts = 0.0;
        this.nbExpenses = 0;
        this.expenses = 0.0;
        this.refresh(this.data.getTransactions(), true);
        LOGGER.trace("Full stat update done on {} transactions", (Object)this.data.getTransactionsNumber());
        this.needRefresh = false;
    }

    private void refresh(Iterable<Transaction> transactions, boolean add) {
        for (Transaction transaction : transactions) {
            double amount = transaction.getAmount();
            if (amount < 0.0) {
                if (add) {
                    ++this.nbExpenses;
                    this.expenses += amount;
                    continue;
                }
                --this.nbExpenses;
                this.expenses -= amount;
                continue;
            }
            if (add) {
                ++this.nbReceipts;
                this.receipts += amount;
                continue;
            }
            --this.nbReceipts;
            this.receipts -= amount;
        }
    }

    private void fireChanged() {
        this.setChanged();
        this.notifyObservers();
    }
}

