/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import net.yapbam.data.Account;
import net.yapbam.data.BalanceHistory;
import net.yapbam.data.Transaction;
import net.yapbam.util.NullUtils;

public class Statement {
    private String id;
    private double positiveBalance;
    private double negativeBalance;
    private int nbTransactions;
    private long dateSum;
    private double startBalance;

    public static Statement[] getStatements(Account account) {
        HashMap<String, Statement> map = new HashMap<String, Statement>();
        BalanceHistory balanceHistory = account.getBalanceData().getBalanceHistory();
        for (int i = 0; i < balanceHistory.getTransactionsNumber(); ++i) {
            Transaction transaction = balanceHistory.getTransaction(i);
            if (!transaction.getAccount().getName().equals(account.getName())) continue;
            String statementId = transaction.getStatement();
            Statement statement = (Statement)map.get(statementId);
            if (statement == null) {
                statement = new Statement(statementId);
                map.put(statementId, statement);
            }
            statement.add(transaction);
        }
        Statement[] statements = map.values().toArray(new Statement[map.size()]);
        Arrays.sort(statements, new Comparator<Statement>(){

            @Override
            public int compare(Statement o2, Statement o1) {
                if (o2.getId() == null || o1.getId() == null) {
                    return NullUtils.compareTo((Comparable)((Object)o2.getId()), (Comparable)((Object)o1.getId()), false);
                }
                int result = o2.getMediumDate() - o1.getMediumDate();
                if (result == 0) {
                    result = NullUtils.compareTo((Comparable)((Object)o2.getId()), (Comparable)((Object)o1.getId()), false);
                }
                return result;
            }
        });
        if (statements.length == 0) {
            statements = new Statement[]{new Statement(null)};
        }
        statements[0].setStartBalance(account.getInitialBalance());
        for (int i = 1; i < statements.length; ++i) {
            statements[i].setStartBalance(statements[i - 1].getEndBalance());
        }
        return statements;
    }

    public Statement(String id, double startBalance) {
        this(id);
        this.setStartBalance(startBalance);
    }

    private Statement(String id) {
        this.id = id;
        this.positiveBalance = 0.0;
        this.negativeBalance = 0.0;
        this.nbTransactions = 0;
        this.dateSum = 0L;
    }

    private void add(Transaction transaction) {
        ++this.nbTransactions;
        double amount = transaction.getAmount();
        if (amount > 0.0) {
            this.positiveBalance += amount;
        } else {
            this.negativeBalance -= amount;
        }
        this.dateSum += (long)transaction.getValueDateAsInteger();
    }

    public int getMediumDate() {
        return (int)(this.dateSum / (long)this.nbTransactions);
    }

    public String getId() {
        return this.id;
    }

    public double getBalance() {
        return this.positiveBalance - this.negativeBalance;
    }

    public int getNbTransactions() {
        return this.nbTransactions;
    }

    public String toString() {
        return this.getId();
    }

    private void setStartBalance(double startBalance) {
        this.startBalance = startBalance;
    }

    public double getPositiveBalance() {
        return this.positiveBalance;
    }

    public double getNegativeBalance() {
        return this.negativeBalance;
    }

    public double getStartBalance() {
        return this.startBalance;
    }

    public double getEndBalance() {
        return this.startBalance + this.getBalance();
    }
}

