/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data.event;

import net.yapbam.data.Account;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Mode;
import net.yapbam.data.event.DataEvent;
import net.yapbam.util.NullUtils;

public class ModePropertyChangedEvent
extends DataEvent {
    public static final int NAME = 1;
    public static final int EXPENSE_VDC = 2;
    public static final int RECEIPT_VDC = 4;
    public static final int CHECKBOOK = 8;
    private int changes;
    private Account account;
    private Mode oldMode;
    private Mode newMode;

    public ModePropertyChangedEvent(GlobalData globalData, Account account, Mode oldMode, Mode newMode) {
        super(globalData);
        this.account = account;
        this.oldMode = oldMode;
        this.newMode = newMode;
        this.changes = 0;
        if (!NullUtils.areEquals(oldMode.getName(), newMode.getName())) {
            ++this.changes;
        }
        if (!NullUtils.areEquals(oldMode.getExpenseVdc(), newMode.getExpenseVdc())) {
            this.changes += 2;
        }
        if (!NullUtils.areEquals(oldMode.getReceiptVdc(), newMode.getReceiptVdc())) {
            this.changes += 4;
        }
        if (oldMode.isUseCheckBook() != newMode.isUseCheckBook()) {
            this.changes += 8;
        }
    }

    public int getChanges() {
        return this.changes;
    }

    public Account getAccount() {
        return this.account;
    }

    public Mode getOldMode() {
        return this.oldMode;
    }

    public Mode getNewMode() {
        return this.newMode;
    }
}

