/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.yapbam.data.GlobalData;
import net.yapbam.data.ProgressReport;
import net.yapbam.data.xml.AbstractSerializer;
import net.yapbam.data.xml.XMLSerializer;

public class Serializer
extends AbstractSerializer<GlobalData> {
    private static final byte[] MAGIC_ZIP_BYTES = new byte[]{80, 75, 3, 4};

    public void writeToZip(GlobalData data, ZipOutputStream out, String entryName, ProgressReport report) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        out.putNextEntry(entry);
        this.write(data, out, report);
        out.closeEntry();
    }

    public void write(GlobalData data, OutputStream out, ProgressReport report) throws IOException {
        super.write(data, out, data.getPassword(), report);
    }

    @Override
    public void directWrite(GlobalData data, OutputStream out, ProgressReport report) throws IOException {
        XMLSerializer xmlSerializer = new XMLSerializer(out);
        xmlSerializer.serialize(data, report);
        xmlSerializer.closeDocument();
    }

    private static boolean isZippedInputStream(InputStream in) throws IOException {
        in.mark(MAGIC_ZIP_BYTES.length);
        boolean isZipped = true;
        for (int i = 0; i < MAGIC_ZIP_BYTES.length - 1; ++i) {
            if (in.read() == MAGIC_ZIP_BYTES[i]) continue;
            isZipped = false;
            break;
        }
        in.reset();
        return isZipped;
    }

    @Override
    public GlobalData read(String password, InputStream in, ProgressReport report) throws IOException, AccessControlException {
        boolean isZipped;
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        if (isZipped = Serializer.isZippedInputStream(in)) {
            in = new ZipInputStream(in);
            ((ZipInputStream)in).getNextEntry();
            if (!in.markSupported()) {
                in = new BufferedInputStream(in);
            }
        }
        return (GlobalData)super.read(password, in, report);
    }

    @Override
    public GlobalData directRead(String password, InputStream in, ProgressReport report) throws IOException {
        GlobalData result = XMLSerializer.read(in, report);
        if (result != null) {
            result.setPassword(password);
        }
        return result;
    }

    @Override
    public boolean isPasswordOk(InputStream in, String password) throws IOException {
        boolean isZipped = Serializer.isZippedInputStream(in);
        if (isZipped) {
            in = new ZipInputStream(in);
            ((ZipInputStream)in).getNextEntry();
            if (!in.markSupported()) {
                in = new BufferedInputStream(in);
            }
        }
        return super.isPasswordOk(in, password);
    }
}

