/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data.xml.task;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.concurrent.Callable;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import net.yapbam.util.Base64Encoder;
import net.yapbam.util.BinaryPBEKey;
import net.yapbam.util.StreamUtils;

public class EncrypterTask
implements Callable<Void> {
    public static final String UTF8 = "UTF-8";
    private static final byte[] SALT = new byte[]{-57, 35, -91, -4, 126, 56, -18, 9};
    static final String ALGORITHM = "PBEWITHMD5ANDDES";
    static final PBEParameterSpec PBE_PARAM_SPEC = new PBEParameterSpec(SALT, 16);
    private InputStream in;
    private OutputStream out;
    private boolean compatibilityMode;
    private String password;

    public EncrypterTask(InputStream in, OutputStream out, String password, boolean compatibilityMode) {
        this.in = in;
        this.out = out;
        this.password = password;
        this.compatibilityMode = compatibilityMode;
    }

    static Cipher getCipher(int mode, String password, boolean compatibilityMode) throws GeneralSecurityException {
        SecretKey pbeKey = EncrypterTask.getSecretKey(password, compatibilityMode);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(mode, (Key)pbeKey, PBE_PARAM_SPEC);
        return cipher;
    }

    static SecretKey getSecretKey(String password, boolean compatibilityMode) throws InvalidKeySpecException, NoSuchAlgorithmException {
        try {
            if (compatibilityMode) {
                return new BinaryPBEKey(password.getBytes(UTF8));
            }
            password = Base64Encoder.encode(password.getBytes(UTF8));
            return SecretKeyFactory.getInstance(ALGORITHM).generateSecret(new PBEKeySpec(password.toCharArray()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static byte[] getDigest(String password) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA");
            digest.update(SALT);
            return digest.digest(password.getBytes(UTF8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        this.out.write(EncrypterTask.getDigest(this.password));
        Cipher cipher = EncrypterTask.getCipher(1, this.password, this.compatibilityMode);
        CipherOutputStream po = new CipherOutputStream(this.out, cipher);
        try {
            StreamUtils.copy(this.in, po, new byte[10240]);
            Void void_ = null;
            return void_;
        }
        finally {
            this.in.close();
            po.close();
            this.out.flush();
            this.out.close();
        }
    }
}

