/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui;

import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import net.yapbam.data.Account;
import net.yapbam.data.Filter;
import net.yapbam.gui.AccountSelector;
import net.yapbam.gui.TransactionSelector;
import net.yapbam.gui.YapbamInstance;
import net.yapbam.gui.YapbamState;
import net.yapbam.gui.dialogs.preferences.PreferencePanel;

public abstract class AbstractPlugIn
implements AccountSelector {
    public static final int FILE_MANIPULATION_PART = 1;
    public static final int PREFERENCES_PART = 2;
    public static final int ACCOUNTS_PART = 3;
    public static final int TRANSACTIONS_PART = 4;
    public static final int PERIODIC_TRANSACTIONS_PART = 5;
    public static final int ABOUT_PART = 6;
    public static final int UPDATES_PART = 7;
    public static final int IMPORT_EXPORT_PART = 8;
    public static final int WEB_SITES_PART = 9;
    public static final int FILTER_MENU = 2;
    public static final int TRANSACTIONS_MENU = 1;
    public static final String PANEL_ICON_PROPERTY_NAME = "panelIcon";
    public static final String PANEL_TOOLTIP_PROPERTY_NAME = "panelTooltip";
    public static final String PANEL_TITLE_PROPERTY_NAME = "panelTitle";
    public static final String PRINTING_SUPPORTED_PROPERTY_NAME = "printing";
    public static final String FILTER_SUPPORTED_PROPERTY_NAME = "filter";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Icon panelIcon = null;
    private String panelToolTip = null;
    private String panelTitle = null;
    private boolean printSupport = false;
    private YapbamInstance context;

    protected AbstractPlugIn() {
    }

    void setContext(YapbamInstance context) {
        this.context = context;
    }

    public YapbamInstance getContext() {
        return this.context;
    }

    public JMenu[] getPlugInMenu() {
        return null;
    }

    public JMenuItem[] getMenuItem(int part) {
        return null;
    }

    public JPanel getPanel() {
        return null;
    }

    public final Icon getPanelIcon() {
        return this.panelIcon;
    }

    public final void setPanelIcon(Icon panelIcon) {
        if (this.panelIcon != panelIcon) {
            Icon old = this.panelIcon;
            this.panelIcon = panelIcon;
            this.getPropertyChangeSupport().firePropertyChange(PANEL_ICON_PROPERTY_NAME, old, panelIcon);
        }
    }

    public final String getPanelTitle() {
        return this.panelTitle;
    }

    public final void setPanelTitle(String title) {
        if (!NullUtils.areEquals(this.panelTitle, title)) {
            String old = this.panelTitle;
            this.panelTitle = title;
            this.getPropertyChangeSupport().firePropertyChange(PANEL_TITLE_PROPERTY_NAME, old, title);
        }
    }

    public final String getPanelToolTip() {
        return this.panelToolTip;
    }

    public final void setPanelToolTip(String tooltip) {
        if (!NullUtils.areEquals(this.panelToolTip, tooltip)) {
            String old = this.panelToolTip;
            this.panelToolTip = tooltip;
            this.getPropertyChangeSupport().firePropertyChange(PANEL_TOOLTIP_PROPERTY_NAME, old, tooltip);
        }
    }

    public void setDisplayed(boolean displayed) {
    }

    public boolean allowMenu(int menuId) {
        return true;
    }

    public void saveState() {
    }

    public void restoreState() {
    }

    public Object getRestartData() {
        return null;
    }

    public PreferencePanel getPreferencePanel() {
        return null;
    }

    public PreferencePanel getLFPreferencePanel() {
        return null;
    }

    public final boolean isPrintingSupported() {
        return this.printSupport;
    }

    public final void setPrintingSupported(boolean supported) {
        if (supported != this.printSupport) {
            this.printSupport = supported;
            this.propertyChangeSupport.firePropertyChange(PRINTING_SUPPORTED_PROPERTY_NAME, !supported, supported);
        }
    }

    public void print() throws PrinterException {
        String prefix;
        PrintRequestAttributeSet attributes;
        PrinterJob job = PrinterJob.getPrinterJob();
        boolean doPrint = job.printDialog(attributes = YapbamState.INSTANCE.restorePrinterSettings(prefix = this.getClass().getCanonicalName()));
        if (doPrint) {
            YapbamState.INSTANCE.savePrinterSettings(prefix, attributes);
            job.setPrintable(this.getPrintable());
            try {
                job.print(attributes);
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
        }
    }

    protected Printable getPrintable() {
        return null;
    }

    public final PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public TransactionSelector getTransactionSelector() {
        return null;
    }

    @Override
    public Account getSelectedAccount() {
        Filter filter;
        List<Account> filterAccounts;
        if (this.allowMenu(2) && (filterAccounts = (filter = this.getContext().getCurrentTransactionSelector().getFilteredData().getFilter()).getValidAccounts()) != null && filterAccounts.size() == 1) {
            return filterAccounts.get(0);
        }
        return null;
    }
}

