/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui;

import com.fathzer.soft.ajlib.swing.framework.Application;
import com.fathzer.soft.jclop.dropbox.swing.MessagePack;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import javax.swing.JComponent;
import net.yapbam.data.GlobalData;
import net.yapbam.gui.Preferences;

public abstract class LocalizationData {
    public static final Locale SYS_LOCALE = new Locale(System.getProperty("user.language"), System.getProperty("user.country"));
    private static com.fathzer.soft.ajlib.utilities.LocalizationData locData;

    public static void reset() {
        Locale locale = Preferences.safeGetLocale();
        GlobalData.setDefaultCurrency(Currency.getInstance(locale));
        Locale.setDefault(locale);
        JComponent.setDefaultLocale(locale);
        locData = new com.fathzer.soft.ajlib.utilities.LocalizationData("com.fathzer.soft.ajlib.Resources");
        locData.add("Resources");
        locData.setTranslatorMode(Preferences.safeIsTranslatorMode());
        com.fathzer.soft.jclop.swing.MessagePack.DEFAULT = locData;
        MessagePack.INSTANCE = locData;
        Application.LOCALIZATION = locData;
    }

    public static String get(String key) {
        return locData.getString(key);
    }

    public static char getChar(String key) {
        return locData.getString(key).charAt(0);
    }

    public static Locale getLocale() {
        return Locale.getDefault();
    }

    public static DecimalFormat getCurrencyInstance() {
        return (DecimalFormat)NumberFormat.getCurrencyInstance(LocalizationData.getLocale());
    }

    public static URL getURL(String document) {
        URL url = LocalizationData.class.getResource("/localization/" + LocalizationData.getLocale().getLanguage() + "/" + document);
        if (url == null) {
            url = LocalizationData.class.getResource("/localization/" + document);
        }
        return url;
    }

    static {
        LocalizationData.reset();
    }
}

