/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.actions;

import com.fathzer.soft.ajlib.swing.Utils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import net.yapbam.data.Transaction;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.TransactionSelector;
import net.yapbam.gui.actions.AbstractTransactionAction;
import net.yapbam.gui.dialogs.AlertDialog;
import net.yapbam.gui.preferences.EditingSettings;

public class DeleteTransactionAction
extends AbstractTransactionAction {
    public DeleteTransactionAction(TransactionSelector selector) {
        super(selector, LocalizationData.get("MainMenu.Transactions.Delete"), IconManager.get(IconManager.Name.DELETE_TRANSACTION), LocalizationData.get("MainMenu.Transactions.Delete.ToolTip"));
        this.putValue("MnemonicKey", LocalizationData.getChar("MainMenu.Transactions.Delete.Mnemonic"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Transaction transaction = this.selector.getSelectedTransactions()[0];
        EditingSettings editingOptions = Preferences.INSTANCE.getEditionSettings();
        if (editingOptions.isAlertOnModifyChecked() && transaction.getStatement() != null) {
            AlertDialog alert = new AlertDialog(Utils.getOwnerWindow((Component)e.getSource()), LocalizationData.get("DeleteCheckedTransactionAlert.title"), LocalizationData.get("DeleteCheckedTransactionAlert.message"));
            alert.setVisible(true);
            if (alert.getResult() == null) {
                return;
            }
            if (((Boolean)alert.getResult()).booleanValue()) {
                editingOptions.setAlertOnModifyChecked(false);
                Preferences.INSTANCE.setEditingOptions(editingOptions);
            }
        } else if (editingOptions.isAlertOnDelete()) {
            AlertDialog alert = new AlertDialog(Utils.getOwnerWindow((Component)e.getSource()), LocalizationData.get("DeleteTransactionAlert.title"), LocalizationData.get("DeleteTransactionAlert.message"));
            alert.setVisible(true);
            if (alert.getResult() == null) {
                return;
            }
            if (((Boolean)alert.getResult()).booleanValue()) {
                editingOptions.setAlertOnDelete(false);
                Preferences.INSTANCE.setEditingOptions(editingOptions);
            }
        }
        this.selector.getFilteredData().getGlobalData().remove(transaction);
    }
}

