/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.actions;

import com.fathzer.soft.ajlib.swing.Utils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import net.yapbam.data.Account;
import net.yapbam.data.Category;
import net.yapbam.data.FilteredData;
import net.yapbam.data.Mode;
import net.yapbam.data.Transaction;
import net.yapbam.gui.AccountSelector;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.TransactionSelector;
import net.yapbam.gui.dialogs.TransactionDialog;

public class NewTransactionAction
extends AbstractAction {
    private FilteredData data;
    private TransactionSelector selector;
    private boolean massMode;
    private AccountSelector accountSelector;

    public NewTransactionAction(FilteredData data, TransactionSelector selector, boolean massMode, AccountSelector accountSelector) {
        super(LocalizationData.get("MainMenu.Transactions.New"), IconManager.get(massMode ? IconManager.Name.NEW_BULK_TRANSACTION : IconManager.Name.NEW_TRANSACTION));
        this.putValue("ShortDescription", LocalizationData.get("MainMenu.Transactions.New.ToolTip"));
        this.putValue("MnemonicKey", LocalizationData.getChar("MainMenu.Transactions.New.Mnemonic"));
        this.data = data;
        this.selector = selector;
        this.massMode = massMode;
        this.accountSelector = accountSelector;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Transaction transaction = null;
        Account defaultAccount = this.accountSelector.getSelectedAccount();
        if (defaultAccount != null) {
            Date today = new Date();
            transaction = new Transaction(today, null, "", null, 0.0, defaultAccount, Mode.UNDEFINED, Category.UNDEFINED, today, null, null);
        }
        Window owner = Utils.getOwnerWindow((Component)e.getSource());
        transaction = TransactionDialog.open(this.data.getGlobalData(), owner, transaction, false, true, this.massMode);
        if (transaction != null && this.selector != null) {
            this.selector.setSelectedTransactions(new Transaction[]{transaction});
        }
    }
}

