/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.administration;

import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.table.JTable;
import com.fathzer.soft.ajlib.swing.table.NimbusPatchBooleanTableCellRenderer;
import com.fathzer.soft.ajlib.swing.table.RowSorter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import net.yapbam.data.Account;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Mode;
import net.yapbam.data.PeriodicalTransaction;
import net.yapbam.data.Transaction;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.data.event.ModeAddedEvent;
import net.yapbam.data.event.ModePropertyChangedEvent;
import net.yapbam.data.event.ModeRemovedEvent;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.administration.AbstractListAdministrationPanel;
import net.yapbam.gui.dialogs.AbstractModeListModel;
import net.yapbam.gui.dialogs.ModeDialog;

class AdministrationModeListPanel
extends AbstractListAdministrationPanel<GlobalData> {
    private Account account;

    public AdministrationModeListPanel(GlobalData data) {
        super(data);
        this.getJTable().setPreferredScrollableViewportSize(new Dimension(1, this.getJTable().getRowHeight() * 6));
        this.getJTable().setRowSorter(new RowSorter<TableModel>(this.getJTable().getModel()));
    }

    @Override
    protected Action getDeleteButtonAction() {
        return new DeleteModeAction();
    }

    @Override
    protected Action getEditButtonAction() {
        return new EditModeAction();
    }

    @Override
    protected Action getNewButtonAction() {
        return new NewModeAction();
    }

    @Override
    protected Action getDuplicateButtonAction() {
        return null;
    }

    private TableModel getTableModel() {
        return new ModeListTableModel();
    }

    public void setContent(Account account) {
        this.account = account;
        this.getNewButton().getAction().setEnabled(account != null);
        ((AbstractTableModel)this.getJTable().getModel()).fireTableDataChanged();
    }

    @Override
    protected javax.swing.JTable instantiateJTable() {
        JTable table = new JTable(this.getTableModel());
        table.setDefaultRenderer(Boolean.class, new NimbusPatchBooleanTableCellRenderer());
        return table;
    }

    private boolean isUsed(Mode mode) {
        int i;
        GlobalData gData = (GlobalData)this.data;
        for (i = 0; i < gData.getTransactionsNumber(); ++i) {
            Transaction transaction = gData.getTransaction(i);
            if (!transaction.getAccount().equals(this.account) || !transaction.getMode().equals(mode)) continue;
            return true;
        }
        for (i = 0; i < gData.getPeriodicalTransactionsNumber(); ++i) {
            PeriodicalTransaction periodicalTransaction = gData.getPeriodicalTransaction(i);
            if (!periodicalTransaction.getAccount().equals(this.account) || !periodicalTransaction.getMode().equals(mode)) continue;
            return true;
        }
        return false;
    }

    class DeleteModeAction
    extends AbstractAction {
        public DeleteModeAction() {
            super(LocalizationData.get("GenericButton.delete"), IconManager.get(IconManager.Name.DELETE_MODE));
            this.putValue("ShortDescription", LocalizationData.get("ModeDialog.Delete.tooltip"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = AdministrationModeListPanel.this.getJTable().convertRowIndexToModel(AdministrationModeListPanel.this.getJTable().getSelectedRow());
            Mode mode = ((ModeListTableModel)AdministrationModeListPanel.this.getJTable().getModel()).getMode(selectedRow);
            boolean confirmed = true;
            if (AdministrationModeListPanel.this.isUsed(mode)) {
                String mess = "<HTML>" + LocalizationData.get("ModeManager.deleteMessage.head") + "<BR>" + LocalizationData.get("ModeManager.deleteMessage.confirm") + "</HTML>";
                Object[] options = new Object[]{LocalizationData.get("GenericButton.ok"), LocalizationData.get("GenericButton.cancel")};
                int ok = JOptionPane.showOptionDialog(AdministrationModeListPanel.this.getJTable(), mess, LocalizationData.get("ModeManager.deleteMessage.title"), 0, 3, null, options, options[1]);
                boolean bl = confirmed = ok == 0;
            }
            if (confirmed) {
                ((GlobalData)AdministrationModeListPanel.this.data).remove(AdministrationModeListPanel.this.account, mode);
            }
        }
    }

    class EditModeAction
    extends AbstractAction {
        public EditModeAction() {
            super(LocalizationData.get("GenericButton.edit"), IconManager.get(IconManager.Name.EDIT_MODE));
            this.putValue("ShortDescription", LocalizationData.get("ModeDialog.Edit.tooltip"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = AdministrationModeListPanel.this.getJTable().convertRowIndexToModel(AdministrationModeListPanel.this.getJTable().getSelectedRow());
            Mode old = AdministrationModeListPanel.this.account.getMode(row + 1);
            ModeDialog dialog = new ModeDialog(Utils.getOwnerWindow((Component)e.getSource()), AdministrationModeListPanel.this.account);
            dialog.setContent(old);
            dialog.setVisible(true);
            Mode mode = (Mode)dialog.getResult();
            if (mode != null) {
                ((GlobalData)AdministrationModeListPanel.this.data).setMode(AdministrationModeListPanel.this.account, old, mode);
            }
        }
    }

    class NewModeAction
    extends AbstractAction {
        public NewModeAction() {
            super(LocalizationData.get("GenericButton.new"), IconManager.get(IconManager.Name.NEW_MODE));
            this.putValue("ShortDescription", LocalizationData.get("ModeDialog.New.tooltip"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ModeDialog dialog = new ModeDialog(Utils.getOwnerWindow((Component)e.getSource()), AdministrationModeListPanel.this.account);
            dialog.setVisible(true);
            Mode mode = (Mode)dialog.getResult();
            if (mode != null) {
                ((GlobalData)AdministrationModeListPanel.this.data).add(AdministrationModeListPanel.this.account, mode);
            }
        }
    }

    private final class ModeListTableModel
    extends AbstractModeListModel {
        ModeListTableModel() {
            ((GlobalData)AdministrationModeListPanel.this.data).addListener(new DataListener(){

                @Override
                public void processEvent(DataEvent event) {
                    if (event instanceof ModeAddedEvent) {
                        if (AdministrationModeListPanel.this.account == ((ModeAddedEvent)event).getAccount()) {
                            int row = AdministrationModeListPanel.this.account.indexOf(((ModeAddedEvent)event).getMode()) - 1;
                            ModeListTableModel.this.fireTableRowsInserted(row, row);
                        }
                    } else if (event instanceof ModeRemovedEvent) {
                        ModeRemovedEvent e = (ModeRemovedEvent)event;
                        if (AdministrationModeListPanel.this.account == ((ModeRemovedEvent)event).getAccount()) {
                            int row = e.getIndex() - 1;
                            ModeListTableModel.this.fireTableRowsDeleted(row, row);
                        }
                    } else if (event instanceof ModePropertyChangedEvent && AdministrationModeListPanel.this.account == ((ModePropertyChangedEvent)event).getAccount()) {
                        int row = AdministrationModeListPanel.this.account.indexOf(((ModePropertyChangedEvent)event).getNewMode()) - 1;
                        ModeListTableModel.this.fireTableRowsUpdated(row, row);
                    }
                }
            });
        }

        @Override
        public int getRowCount() {
            return AdministrationModeListPanel.this.account == null ? 0 : AdministrationModeListPanel.this.account.getModesNumber() - 1;
        }

        @Override
        protected Mode getMode(int rowIndex) {
            return AdministrationModeListPanel.this.account.getMode(rowIndex + 1);
        }
    }
}

