/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.administration.filter;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.Utils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import net.yapbam.data.Filter;
import net.yapbam.data.GlobalData;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.administration.filter.FilterDialog;
import net.yapbam.gui.administration.filter.FilterListPanel;
import net.yapbam.gui.dialogs.CustomFilterDialog;

public class DuplicateFilterAction
extends AbstractAction {
    private FilterListPanel panel;

    public DuplicateFilterAction(FilterListPanel panel) {
        super(LocalizationData.get("GenericButton.duplicate"), IconManager.get(IconManager.Name.DUPLICATE_TRANSACTION));
        this.putValue("ShortDescription", LocalizationData.get("FilterManager.duplicates.tooltip"));
        this.panel = panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTable table = this.panel.getJTable();
        int index = table.convertRowIndexToModel(table.getSelectedRow());
        final Filter filter = new Filter();
        filter.copy(this.panel.getData().getFilter(index));
        filter.setName(null);
        Window owner = e.getSource() instanceof Component ? Utils.getOwnerWindow((Component)e.getSource()) : null;
        CustomFilterDialog.FilterData filterData = new CustomFilterDialog.FilterData(){

            @Override
            public GlobalData getGlobalData() {
                return DuplicateFilterAction.this.panel.getData();
            }

            @Override
            public Filter getFilter() {
                return filter;
            }
        };
        FilterDialog dialog = new FilterDialog(owner, filterData);
        dialog.setFilterName(this.getCopyName(this.panel.getData(), this.panel.getData().getFilter(index).getName()));
        dialog.setVisible(true);
        Boolean result = (Boolean)dialog.getResult();
        if (result != null && result.booleanValue()) {
            filterData.getGlobalData().add(filter);
        }
    }

    private String getCopyName(GlobalData data, String name) {
        String candidate = Formatter.format("{0} - copy", name);
        if (data.getFilter(candidate) == null) {
            return candidate;
        }
        name = candidate;
        for (long i = 1L; i < Long.MAX_VALUE; ++i) {
            candidate = name + " - " + i;
            if (data.getFilter(candidate) != null) continue;
            return candidate;
        }
        throw new IllegalArgumentException("Unable to find an available copy name");
    }
}

