/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.administration.filter;

import com.fathzer.soft.ajlib.swing.Utils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import net.yapbam.data.Filter;
import net.yapbam.data.GlobalData;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.administration.filter.FilterDialog;
import net.yapbam.gui.administration.filter.FilterListPanel;
import net.yapbam.gui.administration.filter.FiltersTableModel;
import net.yapbam.gui.dialogs.CustomFilterDialog;

public class EditFilterAction
extends AbstractAction {
    private FilterListPanel panel;

    public EditFilterAction(FilterListPanel panel) {
        super(LocalizationData.get("GenericButton.edit"), IconManager.get(IconManager.Name.EDIT_TRANSACTION));
        this.putValue("ShortDescription", LocalizationData.get("FilterManager.edit.tooltip"));
        this.panel = panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTable table = this.panel.getJTable();
        int index = table.convertRowIndexToModel(table.getSelectedRow());
        final Filter filter = this.panel.getData().getFilter(index);
        Window owner = e.getSource() instanceof Component ? Utils.getOwnerWindow((Component)e.getSource()) : null;
        CustomFilterDialog.FilterData filterData = new CustomFilterDialog.FilterData(){

            @Override
            public GlobalData getGlobalData() {
                return EditFilterAction.this.panel.getData();
            }

            @Override
            public Filter getFilter() {
                return filter;
            }
        };
        FilterDialog dialog = new FilterDialog(owner, filterData);
        dialog.setVisible(true);
        Boolean result = (Boolean)dialog.getResult();
        if (result != null && result.booleanValue()) {
            ((FiltersTableModel)this.panel.getJTable().getModel()).update(index);
        }
    }
}

