/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.archive;

import com.fathzer.soft.ajlib.swing.dialog.AbstractDialog;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.JPanel;
import net.yapbam.data.Account;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Transaction;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.archive.StatementSelectionPanel;
import net.yapbam.gui.archive.StatementSelectionTableModel;
import net.yapbam.gui.util.AutoUpdateOkButtonPropertyListener;

public class StatementSelectionDialog
extends AbstractDialog<Object[], Collection<Transaction>> {
    private StatementSelectionPanel panel;

    public StatementSelectionDialog(Window owner, GlobalData data, GlobalData archiveData, CharSequence[] alerts) {
        super(owner, LocalizationData.get("Archive.menu.name"), new Object[]{data, archiveData, alerts});
    }

    @Override
    protected JPanel createCenterPane() {
        this.panel = new StatementSelectionPanel((GlobalData)((Object[])this.data)[0], (GlobalData)((Object[])this.data)[1], (CharSequence[])((Object[])this.data)[2]);
        this.panel.addPropertyChangeListener("invalidityCause", new AutoUpdateOkButtonPropertyListener(this));
        this.panel.addPropertyChangeListener("archiveMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StatementSelectionDialog.this.setTitle(LocalizationData.get((Boolean)evt.getNewValue() != false ? "Archive.menu.name" : "Archive.restore.title"));
            }
        });
        return this.panel;
    }

    @Override
    protected String getOkDisabledCause() {
        return this.panel.getInvalidityCause();
    }

    @Override
    protected Collection<Transaction> buildResult() {
        StatementSelectionTableModel model = (StatementSelectionTableModel)this.panel.getTable().getModel();
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        for (int i = 0; i < this.panel.getSource().getAccountsNumber(); ++i) {
            result.addAll(this.getTransactions(this.panel.getSource().getAccount(i), model.getSelectedStatements(i)));
        }
        return result;
    }

    private Collection<Transaction> getTransactions(Account account, Set<String> statementIds) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        for (int i = 0; i < this.panel.getSource().getTransactionsNumber(); ++i) {
            Transaction transaction = this.panel.getSource().getTransaction(i);
            Account tAccount = transaction.getAccount();
            String tStatement = transaction.getStatement();
            if (!tAccount.equals(account) || !statementIds.contains(tStatement)) continue;
            transactions.add(transaction);
        }
        return transactions;
    }

    public boolean[] isAccountSelected() {
        StatementSelectionTableModel model = (StatementSelectionTableModel)this.panel.getTable().getModel();
        return model.isSelectedAccount();
    }

    public boolean isArchiveMode() {
        return this.panel.isArchiveMode();
    }
}

