/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.budget;

import javax.swing.JPanel;
import net.yapbam.data.FilteredData;
import net.yapbam.gui.AbstractPlugIn;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.YapbamState;
import net.yapbam.gui.budget.BudgetViewPanel;

public class BudgetPlugin
extends AbstractPlugIn {
    private static final String STATE_PREFIX = "BudgetView";
    private static final String SUM_COLUMN = "sumColumn";
    private static final String SUM_LINE = "sumLine";
    private static final String PER_YEAR = "perYear";
    private static final String PER_VALUE_DATE = "perValueDate";
    private static final String GROUP_SUB_CATEGORIES = "grouped.subcategories";
    private FilteredData data;
    private BudgetViewPanel panel;

    public BudgetPlugin(FilteredData filteredData, Object restartData) {
        this.data = filteredData;
        this.setPanelTitle(LocalizationData.get("BudgetPanel.title"));
        this.setPanelToolTip(LocalizationData.get("BudgetPanel.tooltip"));
    }

    @Override
    public JPanel getPanel() {
        this.panel = new BudgetViewPanel(this.data);
        return this.panel;
    }

    @Override
    public void saveState() {
        YapbamState.INSTANCE.put("BudgetViewsumColumn", Boolean.toString(this.panel.getChckbxAddSumColumn().isSelected()));
        YapbamState.INSTANCE.put("BudgetViewsumLine", Boolean.toString(this.panel.getChckbxAddSumLine().isSelected()));
        YapbamState.INSTANCE.put("BudgetViewperYear", Boolean.toString(this.panel.getYear().isSelected()));
        YapbamState.INSTANCE.put("BudgetViewperValueDate", Boolean.toString(this.panel.getValueDate().isSelected()));
        YapbamState.INSTANCE.put("BudgetViewgrouped.subcategories", Boolean.toString(this.panel.getGroupSubCategories().isSelected()));
    }

    @Override
    public void restoreState() {
        boolean perValueDate;
        this.panel.getChckbxAddSumColumn().setSelected(Boolean.parseBoolean(YapbamState.INSTANCE.get("BudgetViewsumColumn", "false")));
        this.panel.getChckbxAddSumLine().setSelected(Boolean.parseBoolean(YapbamState.INSTANCE.get("BudgetViewsumLine", "false")));
        boolean perYear = Boolean.parseBoolean(YapbamState.INSTANCE.get("BudgetViewperYear", "false"));
        if (perYear) {
            this.panel.getYear().setSelected(true);
        }
        if (perValueDate = Boolean.parseBoolean(YapbamState.INSTANCE.get("BudgetViewperValueDate", "false"))) {
            this.panel.getValueDate().setSelected(true);
        }
        this.panel.getGroupSubCategories().setSelected(Boolean.parseBoolean(YapbamState.INSTANCE.get("BudgetViewgrouped.subcategories", "false")));
    }
}

