/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.budget;

import com.fathzer.soft.ajlib.swing.table.TitledRowsTableModel;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import net.yapbam.data.BudgetView;
import net.yapbam.data.Category;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.gui.LocalizationData;

class BudgetTableModel
extends AbstractTableModel
implements TitledRowsTableModel {
    private BudgetView budget;
    private boolean hasExtraLine;
    private boolean hasExtraColumn;

    BudgetTableModel(BudgetView budget) {
        this.budget = budget;
        this.budget.addListener(new DataListener(){

            @Override
            public void processEvent(DataEvent event) {
                BudgetTableModel.this.fireTableStructureChanged();
            }
        });
    }

    @Override
    public int getColumnCount() {
        int count = this.budget.getDatesSize();
        if (this.hasExtraColumn) {
            ++count;
        }
        return count;
    }

    @Override
    public int getRowCount() {
        int count = this.budget.getCategoriesSize();
        if (this.hasExtraLine) {
            ++count;
        }
        return count;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Double value;
        boolean isSumColumn;
        boolean bl = isSumColumn = columnIndex == this.budget.getDatesSize();
        if (rowIndex == this.budget.getCategoriesSize()) {
            value = !isSumColumn ? Double.valueOf(this.budget.getSum(this.budget.getDate(columnIndex))) : this.budget.getSum();
        } else if (isSumColumn) {
            Category category = this.budget.getCategory(rowIndex);
            value = this.budget.getSum(category);
        } else {
            Date date = this.budget.getDate(columnIndex);
            Category category = this.budget.getCategory(rowIndex);
            value = this.budget.getAmount(date, category);
        }
        return value == null || value == 0.0 ? "" : LocalizationData.getCurrencyInstance().format(value);
    }

    @Override
    public String getColumnName(int column) {
        int datesSize = this.budget.getDatesSize();
        if (column < datesSize) {
            Date date = this.budget.getDate(column);
            if (this.budget.isYear()) {
                return "" + (date.getYear() + 1900);
            }
            return new SimpleDateFormat("yyyy/MM").format(date);
        }
        return LocalizationData.get("BudgetPanel.sum");
    }

    public void setHasSumLine(boolean hasExtraLine) {
        if (hasExtraLine != this.hasExtraLine) {
            this.hasExtraLine = hasExtraLine;
            this.fireTableStructureChanged();
        }
    }

    public void setHasSumColumn(boolean hasExtraColumn) {
        if (hasExtraColumn != this.hasExtraColumn) {
            this.hasExtraColumn = hasExtraColumn;
            this.fireTableStructureChanged();
        }
    }

    @Override
    public int getTitlesColumnCount() {
        return 1;
    }

    @Override
    public String getRowTitle(int rowIndex, int columnIndex) {
        if (rowIndex == this.budget.getCategoriesSize()) {
            return LocalizationData.get("BudgetPanel.sum");
        }
        Category category = this.budget.getCategory(rowIndex);
        return category.equals(Category.UNDEFINED) ? LocalizationData.get("Category.undefined") : category.getName();
    }
}

