/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.soft.ajlib.swing.Utils;
import net.yapbam.data.Category;
import net.yapbam.data.GlobalData;
import net.yapbam.data.comparator.CategoryComparator;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.CategoryDialog;
import net.yapbam.gui.widget.AbstractSelector;

public class CategoryWidget
extends AbstractSelector<Category, GlobalData> {
    public static final String CATEGORY_PROPERTY = "category";

    public CategoryWidget(GlobalData data) {
        super(data);
    }

    @Override
    protected String getLabel() {
        return LocalizationData.get("TransactionDialog.category");
    }

    @Override
    protected String getComboTip() {
        return LocalizationData.get("TransactionDialog.category.tooltip");
    }

    @Override
    protected String getNewButtonTip() {
        return LocalizationData.get("TransactionDialog.category.new.tooltip");
    }

    @Override
    protected String getPropertyName() {
        return CATEGORY_PROPERTY;
    }

    @Override
    protected void populateCombo() {
        if (this.getParameters() != null) {
            for (Category category : CategoryComparator.getSortedCategories((GlobalData)this.getParameters(), this.getLocale())) {
                this.getCombo().addItem(category);
            }
        }
    }

    @Override
    protected Object getDefaultRenderedValue(Category category) {
        return category == null ? category : (category.equals(Category.UNDEFINED) ? LocalizationData.get("Category.undefined") : category.getName());
    }

    @Override
    protected Category createNew() {
        if (this.getParameters() != null) {
            return CategoryDialog.open(Utils.getOwnerWindow(this), (GlobalData)this.getParameters());
        }
        return null;
    }
}

