/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import net.yapbam.data.Account;
import net.yapbam.data.Checkbook;
import net.yapbam.data.GlobalData;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.checkbook.CheckbookDialog;

public class CheckNumberWidget
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String NUMBER_PROPERTY = "Number";
    private JComboBox numbers = null;
    private JButton newButton = null;
    private Account account;
    private GlobalData data;
    private String number = null;

    public CheckNumberWidget() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.getNumbers(), gridBagConstraints);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        this.add((Component)this.getNewButton(), gridBagConstraints1);
        Dimension dimension = this.getNumbers().getPreferredSize();
        this.getNewButton().setPreferredSize(new Dimension(dimension.height, dimension.height));
        this.getNumbers().setEditable(true);
    }

    private JComboBox getNumbers() {
        if (this.numbers == null) {
            this.numbers = new JComboBox<String>(new String[0]);
            this.numbers.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        String old = CheckNumberWidget.this.number;
                        CheckNumberWidget.this.number = (String)CheckNumberWidget.this.numbers.getSelectedItem();
                        if (!NullUtils.areEquals(old, CheckNumberWidget.this.number)) {
                            CheckNumberWidget.this.firePropertyChange(CheckNumberWidget.NUMBER_PROPERTY, old, CheckNumberWidget.this.number);
                        }
                    }
                }
            });
        }
        return this.numbers;
    }

    private JButton getNewButton() {
        if (this.newButton == null) {
            this.newButton = new JButton();
            this.newButton.setEnabled(false);
            this.newButton.setIcon(IconManager.get(IconManager.Name.NEW));
            this.newButton.setFocusable(false);
            this.newButton.setToolTipText(LocalizationData.get("TransactionDialog.checkbook.new.tooltip"));
            this.newButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Checkbook book = CheckbookDialog.open(CheckNumberWidget.this.data, CheckNumberWidget.this.account, Utils.getOwnerWindow(CheckNumberWidget.this.newButton));
                    if (book != null) {
                        CheckNumberWidget.this.numbers.addItem(book.getFullNumber(book.getNext()));
                        CheckNumberWidget.this.numbers.setSelectedIndex(CheckNumberWidget.this.numbers.getItemCount() - 1);
                    }
                }
            });
        }
        return this.newButton;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(GlobalData data, Account account) {
        this.data = data;
        this.account = account;
        this.getNewButton().setEnabled(data != null && account != null);
        this.numbers.removeAllItems();
        for (int i = 0; i < account.getCheckbooksNumber(); ++i) {
            Checkbook checkbook = account.getCheckbook(i);
            if (checkbook.isEmpty()) continue;
            this.numbers.addItem(checkbook.getFullNumber(checkbook.getNext()));
        }
    }

    public void setText(String text) {
        this.numbers.setSelectedItem(text == null ? "" : text);
    }

    public String getNumber() {
        return this.number;
    }
}

