/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.soft.ajlib.swing.widget.TextWidget;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.yapbam.data.Account;
import net.yapbam.data.AlertThreshold;
import net.yapbam.data.GlobalData;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.widget.AutoSelectFocusListener;
import net.yapbam.gui.widget.CurrencyWidget;

public class EditAccountPanel
extends JPanel {
    public static final String OK_DISABLED_CAUSE_PROPERTY = "okDisabled";
    private JLabel lblName;
    private TextWidget nameField;
    private JLabel lblInitialBalance;
    private CurrencyWidget initBalanceField;
    private JLabel lblLowThreshold;
    private CurrencyWidget lowThresholdField;
    private JLabel lblHighThreshold;
    private CurrencyWidget hightThresholdField;
    private GlobalData data;
    private String okDisabledCause;
    private int accountIndex;
    private JLabel message;
    private PropertyChangeListener listener;
    private JScrollPane notePane;
    private JTextArea noteField;
    private JLabel lblNotes;

    public EditAccountPanel(GlobalData data) {
        this.data = data;
        this.accountIndex = -1;
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EditAccountPanel.this.updateOkDisabledCause();
            }
        };
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbcMessage = new GridBagConstraints();
        gbcMessage.insets = new Insets(0, 0, 15, 0);
        gbcMessage.anchor = 17;
        gbcMessage.gridwidth = 0;
        gbcMessage.gridx = 0;
        gbcMessage.gridy = 0;
        this.add((Component)this.getMessage(), gbcMessage);
        GridBagConstraints gbcLblName = new GridBagConstraints();
        gbcLblName.insets = new Insets(0, 0, 5, 5);
        gbcLblName.anchor = 17;
        gbcLblName.gridx = 0;
        gbcLblName.gridy = 1;
        this.add((Component)this.getLblName(), gbcLblName);
        GridBagConstraints gbcNameField = new GridBagConstraints();
        gbcNameField.insets = new Insets(0, 0, 5, 0);
        gbcNameField.weightx = 1.0;
        gbcNameField.fill = 2;
        gbcNameField.gridx = 1;
        gbcNameField.gridy = 1;
        this.add((Component)this.getNameField(), gbcNameField);
        GridBagConstraints gbcLblInitialBalance = new GridBagConstraints();
        gbcLblInitialBalance.anchor = 17;
        gbcLblInitialBalance.insets = new Insets(0, 0, 5, 5);
        gbcLblInitialBalance.gridx = 0;
        gbcLblInitialBalance.gridy = 2;
        this.add((Component)this.getLblInitialBalance(), gbcLblInitialBalance);
        GridBagConstraints gbcInitBalanceField = new GridBagConstraints();
        gbcInitBalanceField.insets = new Insets(0, 0, 5, 0);
        gbcInitBalanceField.fill = 2;
        gbcInitBalanceField.gridx = 1;
        gbcInitBalanceField.gridy = 2;
        this.add((Component)this.getInitBalanceField(), gbcInitBalanceField);
        GridBagConstraints gbcLblLowThreshold = new GridBagConstraints();
        gbcLblLowThreshold.anchor = 17;
        gbcLblLowThreshold.insets = new Insets(0, 0, 5, 5);
        gbcLblLowThreshold.gridx = 0;
        gbcLblLowThreshold.gridy = 3;
        this.add((Component)this.getLblLowThreshold(), gbcLblLowThreshold);
        GridBagConstraints gbcLowThresholdField = new GridBagConstraints();
        gbcLowThresholdField.insets = new Insets(0, 0, 5, 0);
        gbcLowThresholdField.fill = 2;
        gbcLowThresholdField.gridx = 1;
        gbcLowThresholdField.gridy = 3;
        this.add((Component)this.getLowThresholdField(), gbcLowThresholdField);
        GridBagConstraints gbcLblHighThreshold = new GridBagConstraints();
        gbcLblHighThreshold.anchor = 17;
        gbcLblHighThreshold.insets = new Insets(0, 0, 5, 5);
        gbcLblHighThreshold.gridx = 0;
        gbcLblHighThreshold.gridy = 4;
        this.add((Component)this.getLblHighThreshold(), gbcLblHighThreshold);
        GridBagConstraints gbcHightThresholdField = new GridBagConstraints();
        gbcHightThresholdField.insets = new Insets(0, 0, 5, 0);
        gbcHightThresholdField.fill = 2;
        gbcHightThresholdField.gridx = 1;
        gbcHightThresholdField.gridy = 4;
        this.add((Component)this.getHightThresholdField(), gbcHightThresholdField);
        GridBagConstraints gbcLblNotes = new GridBagConstraints();
        gbcLblNotes.gridwidth = 0;
        gbcLblNotes.anchor = 17;
        gbcLblNotes.gridx = 0;
        gbcLblNotes.gridy = 5;
        this.add((Component)this.getLblNotes(), gbcLblNotes);
        GridBagConstraints gbcNotePane = new GridBagConstraints();
        gbcNotePane.gridwidth = 0;
        gbcNotePane.fill = 1;
        gbcNotePane.gridx = 0;
        gbcNotePane.gridy = 6;
        this.add((Component)this.getNotePane(), gbcNotePane);
    }

    void setAccount(int accountIndex) {
        this.accountIndex = accountIndex;
        Account account = this.data.getAccount(accountIndex);
        this.getNameField().setText(account.getName());
        this.getInitBalanceField().setValue(account.getInitialBalance());
        this.getLblLowThreshold().setVisible(true);
        double low = account.getAlertThreshold().getLessThreshold();
        this.getLowThresholdField().setValue(low == AlertThreshold.NO.getLessThreshold() ? null : Double.valueOf(low));
        this.getLowThresholdField().setVisible(true);
        this.getLblHighThreshold().setVisible(true);
        double high = account.getAlertThreshold().getMoreThreshold();
        this.getHightThresholdField().setValue(high == AlertThreshold.NO.getMoreThreshold() ? null : Double.valueOf(high));
        this.getHightThresholdField().setVisible(true);
        this.getLblNotes().setVisible(true);
        this.getNotePane().setVisible(true);
        this.getNoteField().setText(account.getComment() == null ? "" : account.getComment());
        this.updateOkDisabledCause();
    }

    void setMessage(String message) {
        this.getMessage().setText(message);
        this.getMessage().setVisible(true);
    }

    private JLabel getLblName() {
        if (this.lblName == null) {
            this.lblName = new JLabel(LocalizationData.get("AccountDialog.account"));
        }
        return this.lblName;
    }

    private TextWidget getNameField() {
        if (this.nameField == null) {
            this.nameField = new TextWidget();
            this.nameField.setToolTipText(LocalizationData.get("AccountDialog.account.tooltip"));
            this.nameField.setColumns(20);
            this.nameField.addPropertyChangeListener("text", this.listener);
        }
        return this.nameField;
    }

    private JLabel getLblInitialBalance() {
        if (this.lblInitialBalance == null) {
            this.lblInitialBalance = new JLabel(LocalizationData.get("AccountDialog.balance"));
        }
        return this.lblInitialBalance;
    }

    private CurrencyWidget getInitBalanceField() {
        if (this.initBalanceField == null) {
            this.initBalanceField = new CurrencyWidget();
            this.initBalanceField.addFocusListener(AutoSelectFocusListener.INSTANCE);
            this.initBalanceField.setToolTipText(LocalizationData.get("AccountDialog.balance.tooltip"));
            this.initBalanceField.addPropertyChangeListener("value", this.listener);
            this.initBalanceField.setValue(new Double(0.0));
        }
        return this.initBalanceField;
    }

    private JLabel getLblLowThreshold() {
        if (this.lblLowThreshold == null) {
            this.lblLowThreshold = new JLabel(LocalizationData.get("AccountDialog.alertThresholdLess"));
            this.lblLowThreshold.setVisible(false);
        }
        return this.lblLowThreshold;
    }

    private CurrencyWidget getLowThresholdField() {
        if (this.lowThresholdField == null) {
            this.lowThresholdField = new CurrencyWidget();
            this.lowThresholdField.addFocusListener(AutoSelectFocusListener.INSTANCE);
            this.lowThresholdField.setEmptyAllowed(true);
            this.lowThresholdField.setToolTipText(LocalizationData.get("AccountDialog.alertThresholdLess.tooltip"));
            this.lowThresholdField.addPropertyChangeListener("contentValid", this.listener);
            this.lowThresholdField.addPropertyChangeListener("value", this.listener);
            this.lowThresholdField.setVisible(false);
        }
        return this.lowThresholdField;
    }

    private JLabel getLblHighThreshold() {
        if (this.lblHighThreshold == null) {
            this.lblHighThreshold = new JLabel(LocalizationData.get("AccountDialog.alertThresholdMore"));
            this.lblHighThreshold.setVisible(false);
        }
        return this.lblHighThreshold;
    }

    private CurrencyWidget getHightThresholdField() {
        if (this.hightThresholdField == null) {
            this.hightThresholdField = new CurrencyWidget();
            this.hightThresholdField.addFocusListener(AutoSelectFocusListener.INSTANCE);
            this.hightThresholdField.setEmptyAllowed(true);
            this.hightThresholdField.setToolTipText(LocalizationData.get("AccountDialog.alertThresholdMore.tooltip"));
            this.hightThresholdField.addPropertyChangeListener("contentValid", this.listener);
            this.hightThresholdField.addPropertyChangeListener("value", this.listener);
            this.hightThresholdField.setVisible(false);
        }
        return this.hightThresholdField;
    }

    private void updateOkDisabledCause() {
        AlertThreshold alerts;
        String old = this.okDisabledCause;
        String name = this.getAccountName();
        this.okDisabledCause = name.length() == 0 ? LocalizationData.get("AccountDialog.err1") : (!this.isNameOk(name) ? LocalizationData.get("AccountDialog.err2") : (this.getInitBalanceField().getValue() == null ? LocalizationData.get("AccountDialog.err3") : (!this.getLowThresholdField().isContentValid() ? LocalizationData.get("AccountDialog.err4") : (!this.getHightThresholdField().isContentValid() ? LocalizationData.get("AccountDialog.err5") : ((alerts = this.getAlerts()).getLessThreshold() >= alerts.getMoreThreshold() ? LocalizationData.get("AccountDialog.err6") : null)))));
        if (!NullUtils.areEquals(old, this.okDisabledCause)) {
            this.firePropertyChange(OK_DISABLED_CAUSE_PROPERTY, old, this.okDisabledCause);
        }
    }

    private String getAccountName() {
        return this.getNameField().getText().trim();
    }

    private AlertThreshold getAlerts() {
        if (this.getLowThresholdField().isContentValid() && this.getHightThresholdField().isContentValid()) {
            AlertThreshold result;
            Double high;
            Double low = this.getLowThresholdField().getValue();
            if (low == null) {
                low = AlertThreshold.NO.getLessThreshold();
            }
            if ((high = this.getHightThresholdField().getValue()) == null) {
                high = AlertThreshold.NO.getMoreThreshold();
            }
            if ((result = new AlertThreshold(low, high)).equals(AlertThreshold.NO)) {
                return AlertThreshold.NO;
            }
            if (result.equals(AlertThreshold.DEFAULT)) {
                return AlertThreshold.DEFAULT;
            }
            return result;
        }
        return null;
    }

    String getOkDisabledCause() {
        return this.okDisabledCause;
    }

    private JLabel getMessage() {
        if (this.message == null) {
            this.message = new JLabel();
            this.message.setVisible(false);
        }
        return this.message;
    }

    Account getAccount() {
        if (this.okDisabledCause != null) {
            return null;
        }
        return new Account(this.getNameField().getText().trim(), this.getInitBalanceField().getValue(), this.getAlerts(), this.getNoteField().getText());
    }

    private boolean isNameOk(String name) {
        for (int i = 0; i < this.data.getAccountsNumber(); ++i) {
            if (i == this.accountIndex || !name.equalsIgnoreCase(this.data.getAccount(i).getName().trim())) continue;
            return false;
        }
        return true;
    }

    private JScrollPane getNotePane() {
        if (this.notePane == null) {
            this.notePane = new JScrollPane(this.getNoteField());
            this.notePane.setPreferredSize(new Dimension(100, 200));
            this.notePane.setVisible(false);
        }
        return this.notePane;
    }

    private JTextArea getNoteField() {
        if (this.noteField == null) {
            this.noteField = new JTextArea();
            this.noteField.setToolTipText(LocalizationData.get("AccountDialog.notes.tooltip"));
            this.noteField.setLineWrap(true);
            this.noteField.setWrapStyleWord(true);
        }
        return this.noteField;
    }

    private JLabel getLblNotes() {
        if (this.lblNotes == null) {
            this.lblNotes = new JLabel(LocalizationData.get("AccountDialog.notes"));
            this.lblNotes.setVisible(false);
        }
        return this.lblNotes;
    }
}

