/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.soft.ajlib.swing.widget.TextWidget;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.yapbam.data.Category;
import net.yapbam.data.GlobalData;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.CategoryWidget;
import net.yapbam.gui.widget.AutoSelectFocusListener;
import net.yapbam.gui.widget.CurrencyWidget;

public class SubTransactionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String AMOUNT_PROPERTY = "amount";
    public static final String DESCRIPTION_PROPERTY = "description";
    private static final String CATEGORY_PROPERTY = "category";
    private TextWidget descriptionField = null;
    private CurrencyWidget amountField = null;
    private CategoryWidget categoryPanel = null;
    private JCheckBox receiptCheckBox = null;
    private GlobalData data;
    private Double amount;
    private PredefinedDescriptionUpdater updater;

    public SubTransactionPanel(GlobalData data) {
        this.data = data;
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gbcReceiptCheckBox = new GridBagConstraints();
        gbcReceiptCheckBox.gridx = 2;
        gbcReceiptCheckBox.anchor = 17;
        gbcReceiptCheckBox.gridy = 1;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.anchor = 17;
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints11.gridy = 2;
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(LocalizationData.get("TransactionDialog.category"));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints4.gridwidth = 2;
        gridBagConstraints4.gridy = 2;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints3.gridx = 1;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.gridy = 1;
        JLabel jLabel1 = new JLabel();
        jLabel1.setText(LocalizationData.get("TransactionDialog.amount"));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints1.gridx = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText(LocalizationData.get("TransactionDialog.description"));
        this.setSize(333, 106);
        this.setLayout(new GridBagLayout());
        this.add((Component)jLabel, gridBagConstraints);
        this.add((Component)this.getDescriptionField(), gridBagConstraints1);
        this.add((Component)jLabel1, gridBagConstraints2);
        this.add((Component)this.getAmountField(), gridBagConstraints3);
        this.add((Component)this.getCategoryPanel(), gridBagConstraints4);
        this.add((Component)jLabel2, gridBagConstraints11);
        this.add((Component)this.getReceiptCheckBox(), gbcReceiptCheckBox);
        this.descriptionField.addPropertyChangeListener("text", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SubTransactionPanel.this.firePropertyChange(SubTransactionPanel.DESCRIPTION_PROPERTY, evt.getOldValue(), evt.getNewValue());
            }
        });
        this.descriptionField.addFocusListener(AutoSelectFocusListener.INSTANCE);
        this.amount = this.amountField.getValue();
        this.amountField.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Double old = SubTransactionPanel.this.amount;
                SubTransactionPanel.this.amount = SubTransactionPanel.this.amountField.getValue();
                if (!SubTransactionPanel.this.receiptCheckBox.isSelected() && SubTransactionPanel.this.amount != null) {
                    SubTransactionPanel.this.amount = -SubTransactionPanel.this.amount.doubleValue();
                }
                SubTransactionPanel.this.firePropertyChange(SubTransactionPanel.AMOUNT_PROPERTY, old, SubTransactionPanel.this.amount);
            }
        });
        this.amountField.addFocusListener(AutoSelectFocusListener.INSTANCE);
    }

    private TextWidget getDescriptionField() {
        if (this.descriptionField == null) {
            this.descriptionField = new TextWidget();
            this.descriptionField.setToolTipText(LocalizationData.get("SubTransactionDialog.description.tooltip"));
            this.descriptionField.setColumns(50);
            this.descriptionField.addPropertyChangeListener("PREDEFINED_VALUE", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (SubTransactionPanel.this.updater != null && evt.getNewValue() != null) {
                        if (SubTransactionPanel.this.getAmount() != null) {
                            SubTransactionPanel.this.setAmount(SubTransactionPanel.this.updater.getAmount((String)evt.getNewValue(), SubTransactionPanel.this.getAmount()));
                        }
                        SubTransactionPanel.this.setCategory(SubTransactionPanel.this.updater.getCategory((String)evt.getNewValue()));
                    }
                }
            });
        }
        return this.descriptionField;
    }

    public void setUpdater(PredefinedDescriptionUpdater updater) {
        this.updater = updater;
    }

    private CurrencyWidget getAmountField() {
        if (this.amountField == null) {
            this.amountField = new CurrencyWidget(LocalizationData.getLocale());
            this.amountField.setToolTipText(LocalizationData.get("SubTransactionDialog.amount.tooltip"));
            this.amountField.setColumns(10);
            this.amountField.setValue(new Double(0.0));
        }
        return this.amountField;
    }

    private CategoryWidget getCategoryPanel() {
        if (this.categoryPanel == null) {
            this.categoryPanel = new CategoryWidget(this.data);
            this.categoryPanel.getJLabel().setVisible(false);
            this.categoryPanel.addPropertyChangeListener(CATEGORY_PROPERTY, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SubTransactionPanel.this.firePropertyChange(SubTransactionPanel.CATEGORY_PROPERTY, evt.getOldValue(), evt.getNewValue());
                }
            });
        }
        return this.categoryPanel;
    }

    private JCheckBox getReceiptCheckBox() {
        if (this.receiptCheckBox == null) {
            this.receiptCheckBox = new JCheckBox();
            this.receiptCheckBox.setText(LocalizationData.get("TransactionDialog.receipt"));
            this.receiptCheckBox.setToolTipText(LocalizationData.get("SubTransactionDialog.receipt.tooltip"));
            this.receiptCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (SubTransactionPanel.this.amount != null && SubTransactionPanel.this.amount != 0.0) {
                        Double old = SubTransactionPanel.this.amount;
                        SubTransactionPanel.this.amount = -SubTransactionPanel.this.amount.doubleValue();
                        SubTransactionPanel.this.firePropertyChange(SubTransactionPanel.AMOUNT_PROPERTY, old, SubTransactionPanel.this.amount);
                    }
                }
            });
        }
        return this.receiptCheckBox;
    }

    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        Double old = this.amount;
        this.receiptCheckBox.setSelected(amount > 0.0);
        this.amountField.setValue(Math.abs(amount));
        this.amount = amount;
        this.firePropertyChange(AMOUNT_PROPERTY, old, amount);
    }

    public String getDescription() {
        return this.descriptionField.getText();
    }

    public void setDescription(String description) {
        this.descriptionField.setText(description);
    }

    public Category getCategory() {
        return (Category)this.getCategoryPanel().get();
    }

    public void setCategory(Category category) {
        this.categoryPanel.set(category);
    }

    public void setPredefined(String[] predefined, int unsortedSize) {
        this.getDescriptionField().setPredefined(predefined, unsortedSize);
    }

    public static interface PredefinedDescriptionUpdater {
        public double getAmount(String var1, double var2);

        public Category getCategory(String var1);
    }
}

