/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.export;

import com.fathzer.soft.ajlib.swing.dialog.AbstractDialog;
import java.awt.Window;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.yapbam.data.FilteredData;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.YapbamState;
import net.yapbam.gui.dialogs.export.ExportPanel;
import net.yapbam.gui.dialogs.export.Exporter;
import net.yapbam.gui.dialogs.export.ExporterParameters;
import net.yapbam.gui.util.AutoUpdateOkButtonPropertyListener;

public class ExportDialog
extends AbstractDialog<FilteredData, Exporter> {
    private ExportPanel exportPanel;

    public ExportDialog(Window owner, FilteredData data) {
        super(owner, LocalizationData.get("ExportDialog.title"), data);
    }

    @Override
    protected Exporter buildResult() {
        ExporterParameters parameters = this.exportPanel.getExporterParameters();
        YapbamState.INSTANCE.save(this.getStateKey(), parameters);
        return new Exporter(parameters);
    }

    private String getStateKey() {
        return this.getClass().getCanonicalName() + ".params";
    }

    private String getOldStateKey() {
        return this.getClass().getCanonicalName() + "." + ExporterParameters.class.getName();
    }

    @Override
    protected JPanel createCenterPane() {
        this.exportPanel = new ExportPanel();
        boolean hasFilter = ((FilteredData)this.data).getFilter().isActive();
        this.exportPanel.getFiltered().setEnabled(hasFilter);
        this.exportPanel.addPropertyChangeListener("invalidityCause", new AutoUpdateOkButtonPropertyListener(this));
        ExporterParameters parameters = (ExporterParameters)YapbamState.INSTANCE.restore(this.getStateKey());
        if (parameters == null && (parameters = (ExporterParameters)YapbamState.INSTANCE.restore(this.getOldStateKey())) != null) {
            YapbamState.INSTANCE.remove(this.getOldStateKey());
            YapbamState.INSTANCE.save(this.getStateKey(), parameters);
        }
        if (parameters != null) {
            if (!hasFilter) {
                parameters.setExportFilteredData(false);
            }
            if (!this.exportPanel.setParameters(parameters)) {
                JOptionPane.showMessageDialog(this.getOwner(), LocalizationData.get("ExportDialog.columnsChangedMessage"), LocalizationData.get("Generic.warning"), 2);
            }
        }
        return this.exportPanel;
    }

    @Override
    protected String getOkDisabledCause() {
        return this.exportPanel.getInvalidityCause();
    }

    @Override
    public void setVisible(boolean visible) {
        this.pack();
        super.setVisible(visible);
    }
}

