/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.export;

import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.export.ExportTableModel;
import net.yapbam.gui.dialogs.export.ExporterParameters;
import net.yapbam.gui.dialogs.export.SeparatorPanel;

public class ExportPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    static final String INVALIDITY_CAUSE = "invalidityCause";
    private JCheckBox title;
    private JRadioButton all;
    private JRadioButton filtered;
    private JTable jTable;
    private JScrollPane jScrollPane;
    private JCheckBox includeInitialBalance;
    private String invalidityCause;
    private SeparatorPanel separatorPanel;
    private ButtonGroup group;

    public String getInvalidityCause() {
        return this.invalidityCause;
    }

    public ExportPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.fill = 2;
        gridBagConstraints12.gridwidth = 0;
        gridBagConstraints12.gridy = 4;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.gridy = 3;
        gridBagConstraints3.gridx = 0;
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 0;
        gridBagConstraints21.gridwidth = 0;
        gridBagConstraints21.gridy = 0;
        gridBagConstraints21.gridx = 0;
        gridBagConstraints21.fill = 1;
        gridBagConstraints21.gridwidth = 0;
        gridBagConstraints21.gridy = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText(LocalizationData.get("ExportDialog.message"));
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.insets = new Insets(10, 0, 15, 0);
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 1;
        gridBagConstraints11.gridwidth = 0;
        gridBagConstraints11.anchor = 17;
        gridBagConstraints11.fill = 0;
        gridBagConstraints11.weighty = 0.0;
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 1;
        gridBagConstraints11.gridwidth = 0;
        gridBagConstraints11.weightx = 1.0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridy = 3;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.gridy = 2;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 2;
        this.setSize(538, 444);
        this.setLayout(new GridBagLayout());
        this.add((Component)jLabel, gridBagConstraints21);
        this.add((Component)this.getJScrollPane(), gridBagConstraints11);
        this.add((Component)this.getTitle(), gridBagConstraints);
        this.add((Component)this.getIncludeInitialBalance(), gridBagConstraints3);
        this.add((Component)this.getAll(), gridBagConstraints1);
        this.add((Component)this.getFiltered(), gridBagConstraints2);
        this.add((Component)this.getSeparatorPanel(), gridBagConstraints12);
        this.group = new ButtonGroup();
        this.group.add(this.getAll());
        this.group.add(this.getFiltered());
    }

    private JCheckBox getTitle() {
        if (this.title == null) {
            this.title = new JCheckBox();
            this.title.setText(LocalizationData.get("ExportDialog.headerCheckbox"));
            this.title.setSelected(true);
            this.title.setToolTipText(LocalizationData.get("ExportDialog.headerCheckbox.toolTip"));
        }
        return this.title;
    }

    private JRadioButton getAll() {
        if (this.all == null) {
            this.all = new JRadioButton();
            this.all.setSelected(true);
            this.all.setText(LocalizationData.get("ExportDialog.allRadioButton"));
            this.all.setToolTipText(LocalizationData.get("ExportDialog.allRadioButton.toolTip"));
        }
        return this.all;
    }

    JRadioButton getFiltered() {
        if (this.filtered == null) {
            this.filtered = new JRadioButton();
            this.filtered.setText(LocalizationData.get("ExportDialog.filteredRadioButton"));
            this.filtered.setToolTipText(LocalizationData.get("ExportDialog.filteredRadioButton.toolTip"));
        }
        return this.filtered;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            ExportTableModel tableModel = new ExportTableModel();
            this.jTable = new JTable(tableModel);
            this.jTable.setAutoResizeMode(0);
            TableCellRenderer renderer = this.jTable.getTableHeader().getDefaultRenderer();
            TableColumnModel columnModel = this.jTable.getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                TableColumn column = columnModel.getColumn(i);
                int w = renderer.getTableCellRendererComponent(null, (Object)column.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
                column.setPreferredWidth(w);
            }
            this.jTable.getTableHeader().setResizingAllowed(false);
            this.jTable.setCellSelectionEnabled(false);
            tableModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    ExportPanel.this.updateIsValid();
                }
            });
        }
        this.jTable.setFocusable(false);
        return this.jTable;
    }

    private void updateIsValid() {
        String old = this.invalidityCause;
        boolean oneSelected = false;
        for (int i = 0; i < this.jTable.getColumnCount(); ++i) {
            if (!((Boolean)this.jTable.getModel().getValueAt(0, i)).booleanValue()) continue;
            oneSelected = true;
            break;
        }
        String string = this.invalidityCause = oneSelected ? null : LocalizationData.get("ExportDialog.nothingToExport");
        if (!NullUtils.areEquals(this.invalidityCause, old)) {
            this.firePropertyChange(INVALIDITY_CAUSE, old, this.invalidityCause);
        }
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
            this.jTable.setPreferredScrollableViewportSize(this.getJTable().getPreferredSize());
        }
        return this.jScrollPane;
    }

    private JCheckBox getIncludeInitialBalance() {
        if (this.includeInitialBalance == null) {
            this.includeInitialBalance = new JCheckBox();
            this.includeInitialBalance.setText(LocalizationData.get("ExportDialog.includeInitialBalanceCheckBox"));
            this.includeInitialBalance.setSelected(true);
            this.includeInitialBalance.setToolTipText(LocalizationData.get("ExportDialog.includeInitialBalanceCheckBox.toolTip"));
        }
        return this.includeInitialBalance;
    }

    private SeparatorPanel getSeparatorPanel() {
        if (this.separatorPanel == null) {
            this.separatorPanel = SeparatorPanel.createColumnSeparatorPanel();
        }
        return this.separatorPanel;
    }

    public ExporterParameters getExporterParameters() {
        ExportTableModel model = (ExportTableModel)this.getJTable().getModel();
        int[] viewToModel = new int[this.getJTable().getColumnCount()];
        boolean[] selected = new boolean[viewToModel.length];
        for (int i = 0; i < viewToModel.length; ++i) {
            int modelColumn;
            viewToModel[i] = modelColumn = this.getJTable().convertColumnIndexToModel(i);
            selected[modelColumn] = (Boolean)model.getValueAt(0, modelColumn);
        }
        return new ExporterParameters(viewToModel, selected, this.title.isSelected(), this.separatorPanel.getSeparator(), this.getIncludeInitialBalance().isSelected(), !this.all.isSelected());
    }

    public boolean setParameters(ExporterParameters parameters) {
        boolean ok;
        this.title.setSelected(parameters.isInsertHeader());
        this.separatorPanel.setSeparator(parameters.getSeparator());
        this.getIncludeInitialBalance().setSelected(parameters.isExportInitialBalance());
        JRadioButton sel = parameters.isExportFilteredData() ? this.filtered : this.all;
        this.group.setSelected(sel.getModel(), true);
        boolean bl = ok = this.jTable.getColumnCount() == parameters.getViewIndexesToModel().length;
        if (ok) {
            for (int i = this.jTable.getColumnCount() - 1; i >= 0; --i) {
                int modelIndex = parameters.getViewIndexesToModel()[i];
                this.jTable.moveColumn(this.jTable.convertColumnIndexToView(modelIndex), i);
            }
            ExportTableModel model = (ExportTableModel)this.jTable.getModel();
            for (int i = 0; i < parameters.getSelectedModelColumns().length; ++i) {
                model.setValueAt(parameters.getSelectedModelColumns()[i], 0, i);
            }
        }
        return ok;
    }
}

