/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.export;

import com.fathzer.soft.ajlib.utilities.CSVWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import net.yapbam.data.Account;
import net.yapbam.data.FilteredData;
import net.yapbam.data.SubTransaction;
import net.yapbam.data.Transaction;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.export.ExportTableModel;
import net.yapbam.gui.dialogs.export.ExporterParameters;

public class Exporter {
    private ExporterParameters parameters;
    private DateFormat dateFormatter;
    private NumberFormat amountFormatter;

    public Exporter(ExporterParameters parameters) {
        this.parameters = parameters;
        this.dateFormatter = SimpleDateFormat.getDateInstance(3, LocalizationData.getLocale());
        this.amountFormatter = CSVWriter.getDecimalFormater(LocalizationData.getLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportFile(File file, FilteredData data) throws IOException {
        OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.parameters.getEncoding());
        try {
            GlobalTransactions transactions;
            int j;
            int i;
            CSVWriter writer = new CSVWriter(fileWriter);
            writer.setSeparator(this.parameters.getSeparator());
            int[] fields = this.parameters.getExportedIndexes();
            if (this.parameters.isInsertHeader()) {
                for (i = 0; i < fields.length; ++i) {
                    writer.writeCell(ExportTableModel.COLUMNS[fields[i]]);
                }
                writer.newLine();
            }
            if (this.parameters.isExportInitialBalance()) {
                for (i = 0; i < data.getGlobalData().getAccountsNumber(); ++i) {
                    Account account = data.getGlobalData().getAccount(i);
                    if (!data.getFilter().isOk(account) && this.parameters.isExportFilteredData()) continue;
                    for (j = 0; j < fields.length; ++j) {
                        writer.writeCell(this.getField(account, fields[j]));
                    }
                    writer.newLine();
                }
            }
            GlobalTransactions globalTransactions = transactions = this.parameters.isExportFilteredData() ? new FilteredTransactions(data) : new GlobalTransactions(data);
            while (transactions.hasNext()) {
                Transaction transaction = (Transaction)transactions.next();
                for (int i2 = 0; i2 < fields.length; ++i2) {
                    writer.writeCell(this.getField(transaction, fields[i2]));
                }
                writer.newLine();
                for (j = 0; j < transaction.getSubTransactionSize(); ++j) {
                    SubTransaction sub = transaction.getSubTransaction(j);
                    for (int i3 = 0; i3 < fields.length; ++i3) {
                        writer.writeCell(this.getField(sub, fields[i3]));
                    }
                    writer.newLine();
                }
            }
            writer.flush();
        }
        finally {
            ((Writer)fileWriter).close();
        }
    }

    private String getField(Account account, int field) {
        String result = null;
        if (field == 1 || field == 5 || field == 6 || field == 7 || field == 9 || field == 8 || field == 2 || field == 3) {
            result = null;
        } else if (field == 0) {
            result = account.getName();
        } else if (field == 4) {
            double amount = account.getInitialBalance();
            result = this.format(amount);
        } else {
            throw new IllegalArgumentException();
        }
        return result == null ? "" : result;
    }

    private String format(double amount) {
        return this.amountFormatter.format(amount);
    }

    private String getField(SubTransaction transaction, int field) {
        String result = null;
        if (field == 0 || field == 1 || field == 6 || field == 7 || field == 9 || field == 8 || field == 3) {
            result = null;
        } else if (field == 4) {
            result = this.format(transaction.getAmount());
        } else if (field == 5) {
            result = transaction.getCategory().getName();
        } else if (field == 2) {
            result = transaction.getDescription();
        } else {
            throw new IllegalArgumentException();
        }
        return result == null ? "" : result;
    }

    private String getField(Transaction transaction, int field) {
        String result = null;
        if (field == 0) {
            result = transaction.getAccount().getName();
        } else if (field == 4) {
            result = this.format(transaction.getAmount());
        } else if (field == 5) {
            result = transaction.getCategory().getName();
        } else if (field == 1) {
            result = this.dateFormatter.format(transaction.getDate());
        } else if (field == 2) {
            result = transaction.getDescription();
        } else if (field == 3) {
            result = transaction.getComment();
        } else if (field == 6) {
            result = transaction.getMode().getName();
        } else if (field == 7) {
            result = transaction.getNumber();
        } else if (field == 9) {
            result = transaction.getStatement();
        } else if (field == 8) {
            result = this.dateFormatter.format(transaction.getValueDate());
        } else {
            throw new IllegalArgumentException();
        }
        return result == null ? "" : result;
    }

    private static class FilteredTransactions
    extends GlobalTransactions {
        private FilteredTransactions(FilteredData data) {
            super(data);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.data.getTransactionsNumber();
        }

        @Override
        public Transaction next() {
            Transaction transaction = this.data.getTransaction(this.index);
            ++this.index;
            return transaction;
        }
    }

    private static class GlobalTransactions
    implements Iterator<Transaction> {
        protected int index = 0;
        protected FilteredData data;

        private GlobalTransactions(FilteredData data) {
            this.data = data;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.data.getGlobalData().getTransactionsNumber();
        }

        @Override
        public Transaction next() {
            Transaction transaction = this.data.getGlobalData().getTransaction(this.index);
            ++this.index;
            return transaction;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

