/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.periodicaltransaction;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.yapbam.data.PeriodicalTransaction;
import net.yapbam.data.Transaction;
import net.yapbam.gui.dialogs.periodicaltransaction.GeneratedTransaction;

class ExtendedPeriodicalTransaction {
    private PeriodicalTransaction transaction;
    private Date postponedDate;
    private Date generationDate;
    private List<GeneratedTransaction> transactions;

    ExtendedPeriodicalTransaction(PeriodicalTransaction transaction) {
        this.transaction = transaction;
        this.postponedDate = null;
        this.generationDate = null;
        this.transactions = new ArrayList<GeneratedTransaction>();
    }

    public PeriodicalTransaction getPeriodicalTransaction() {
        return this.transaction;
    }

    public Date getPosponedDate() {
        return this.postponedDate;
    }

    public void setPosponedDate(Date postponedDate) {
        this.postponedDate = postponedDate;
    }

    public List<GeneratedTransaction> getTransactions(Date date) {
        int length;
        if (date == null) {
            return new ArrayList<GeneratedTransaction>();
        }
        if (this.postponedDate != null && this.postponedDate.compareTo(date) < 0) {
            date = this.postponedDate;
        }
        if (this.generationDate == null || this.generationDate.compareTo(date) < 0) {
            List<Transaction> generated = this.getPeriodicalTransaction().generate(date, null);
            if (this.generationDate == null) {
                this.generationDate = new Date(0L);
            }
            for (Transaction transaction : generated) {
                if (!transaction.getDate().after(this.generationDate)) continue;
                this.transactions.add(new GeneratedTransaction(transaction, this, transaction.getDate()));
            }
            this.generationDate = date;
            return this.transactions;
        }
        for (length = 0; length < this.transactions.size() && this.transactions.get(length).getDate().compareTo(date) <= 0; ++length) {
        }
        return length == 0 ? new ArrayList<GeneratedTransaction>() : this.transactions.subList(0, length);
    }
}

