/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.periodicaltransaction;

import com.fathzer.soft.ajlib.swing.dialog.AbstractDialog;
import java.awt.Window;
import java.util.Arrays;
import java.util.Date;
import javax.swing.JPanel;
import net.yapbam.data.GlobalData;
import net.yapbam.data.PeriodicalTransaction;
import net.yapbam.data.Transaction;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.dialogs.periodicaltransaction.PeriodicalTransactionGeneratorPanel;
import net.yapbam.gui.preferences.EditingSettings;
import net.yapbam.gui.util.AutoUpdateOkButtonPropertyListener;
import net.yapbam.util.DateUtils;

public class GeneratePeriodicalTransactionsDialog
extends AbstractDialog<GlobalData, Void> {
    private PeriodicalTransactionGeneratorPanel panel;

    public GeneratePeriodicalTransactionsDialog(Window owner, GlobalData data) {
        super(owner, LocalizationData.get("GeneratePeriodicalTransactionsDialog.title"), data);
        this.setResizable(true);
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    @Override
    protected Void buildResult() {
        Transaction[] transactions = this.panel.getValidTransactions();
        EditingSettings editingOptions = Preferences.INSTANCE.getEditionSettings();
        if (editingOptions.isAutoFillStatement()) {
            for (int i = 0; i < transactions.length; ++i) {
                Transaction t = transactions[i];
                Date date = editingOptions.isDateBasedAutoStatement() ? t.getDate() : t.getValueDate();
                transactions[i] = new Transaction(t.getDate(), t.getNumber(), t.getDescription(), t.getComment(), t.getAmount(), t.getAccount(), t.getMode(), t.getCategory(), t.getValueDate(), editingOptions.getStatementId(date), Arrays.asList(t.getSubTransactions()));
            }
        }
        ((GlobalData)this.data).add(transactions);
        PeriodicalTransaction[] wholeTransactions = new PeriodicalTransaction[((GlobalData)this.data).getPeriodicalTransactionsNumber()];
        Date[] dates = new Date[wholeTransactions.length];
        for (int i = 0; i < wholeTransactions.length; ++i) {
            wholeTransactions[i] = ((GlobalData)this.data).getPeriodicalTransaction(i);
            dates[i] = this.panel.getDate();
            Date pDate = this.panel.getPostponedDate(i);
            if (pDate == null) continue;
            dates[i] = DateUtils.integerToDate(DateUtils.dateToInteger(pDate) - 1);
        }
        ((GlobalData)this.data).setPeriodicalTransactionNextDate(wholeTransactions, dates);
        return null;
    }

    @Override
    protected JPanel createCenterPane() {
        this.panel = new PeriodicalTransactionGeneratorPanel((GlobalData)this.data);
        this.panel.addPropertyChangeListener("hasImpact", new AutoUpdateOkButtonPropertyListener(this));
        return this.panel;
    }

    @Override
    protected String getOkDisabledCause() {
        if (this.panel.getDate() == null) {
            return LocalizationData.get("GeneratePeriodicalTransactionsDialog.error.date");
        }
        if (!this.panel.hasImpact()) {
            return LocalizationData.get("GeneratePeriodicalTransactionsDialog.error.noTransaction");
        }
        return null;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.panel.restoreState();
        } else {
            this.panel.saveState();
        }
        super.setVisible(visible);
    }
}

