/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.periodicaltransaction;

import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.util.Date;
import net.yapbam.data.AbstractTransaction;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Transaction;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.periodicaltransaction.Generator;
import net.yapbam.gui.transactiontable.GenericTransactionTableModel;
import net.yapbam.gui.transactiontable.TransactionTableUtils;

class GenerateTableModel
extends GenericTransactionTableModel {
    static final int ACCOUNT_INDEX = 0;
    static final int DESCRIPTION_INDEX = 1;
    static final int DATE_INDEX = 2;
    static final int AMOUNT_INDEX = 3;
    static final int CANCELLED_INDEX = 4;
    static final int POSTPONED_INDEX = 5;
    private Generator generator;

    GenerateTableModel(GlobalData data) {
        this.generator = new Generator(data);
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return LocalizationData.get("Transaction.account");
        }
        if (columnIndex == 1) {
            return LocalizationData.get("Transaction.description");
        }
        if (columnIndex == 2) {
            return LocalizationData.get("Transaction.date");
        }
        if (columnIndex == 3) {
            return LocalizationData.get("Transaction.amount");
        }
        if (columnIndex == 4) {
            return LocalizationData.get("GeneratePeriodicalTransactionsDialog.cancelled");
        }
        if (columnIndex == 5) {
            return LocalizationData.get("GeneratePeriodicalTransactionsDialog.postponed");
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 2) {
            return Date.class;
        }
        if (columnIndex == 3) {
            return double[].class;
        }
        if (columnIndex == 4 || columnIndex == 5) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.generator.getNbTransactions();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Transaction t = this.generator.getTransaction(rowIndex);
        if (columnIndex == 0) {
            return t.getAccount().getName();
        }
        if (columnIndex == 1) {
            return TransactionTableUtils.getDescription(t, false, true, false);
        }
        if (columnIndex == 2) {
            return t.getDate();
        }
        if (columnIndex == 3) {
            return new double[]{t.getAmount()};
        }
        if (columnIndex == 4) {
            return this.generator.isCancelled(rowIndex);
        }
        if (columnIndex == 5) {
            return this.generator.isPostponed(rowIndex);
        }
        throw new IllegalArgumentException();
    }

    public boolean isValid(int rowIndex) {
        return !this.generator.isCancelled(rowIndex) && !this.generator.isPostponed(rowIndex);
    }

    public boolean isPostponed(int rowIndex) {
        return this.generator.isPostponed(rowIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 4 || columnIndex == 5;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 4) {
            this.generator.setCancelled(rowIndex, !this.generator.isCancelled(rowIndex));
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        } else if (columnIndex == 5) {
            this.generator.setPostponed(rowIndex, !this.generator.isPostponed(rowIndex));
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void setTransaction(int row, Transaction transaction) {
        this.generator.setTransaction(row, transaction);
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public AbstractTransaction getTransaction(int rowIndex) {
        return this.generator.getTransaction(rowIndex);
    }

    public boolean setDate(Date date) {
        if (NullUtils.areEquals(date, this.generator.getDate())) {
            return false;
        }
        boolean result = this.generator.setDate(date);
        if (result) {
            this.fireTableDataChanged();
        }
        return result;
    }

    public Date getDate() {
        return this.generator.getDate();
    }

    boolean hasImpact() {
        int nb = this.getRowCount();
        if (nb == 0) {
            return false;
        }
        for (int i = 0; i < nb; ++i) {
            if (this.generator.isPostponed(i)) continue;
            return true;
        }
        return false;
    }

    Date getPostponedDate(int indexPeriodical) {
        return this.generator.getPostponedDate(indexPeriodical);
    }
}

