/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.preferences;

import com.fathzer.soft.ajlib.swing.widget.IntegerWidget;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigInteger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.dialogs.preferences.PreferencePanel;

public class AutoUpdatePanel
extends PreferencePanel {
    private static final long serialVersionUID = 1L;
    private JRadioButton auto = null;
    private JRadioButton manual = null;
    private IntegerWidget days = null;
    private JPanel jPanel = null;
    private JRadioButton askMe = null;
    private JRadioButton autoInstall = null;

    public AutoUpdatePanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints51 = new GridBagConstraints();
        gridBagConstraints51.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints51.gridwidth = 0;
        gridBagConstraints51.fill = 1;
        gridBagConstraints51.anchor = 18;
        gridBagConstraints51.gridx = 0;
        gridBagConstraints51.weighty = 1.0;
        gridBagConstraints51.gridy = 3;
        JLabel jLabel2 = new JLabel(UIManager.getIcon("OptionPane.warningIcon"));
        jLabel2.setVerticalAlignment(1);
        jLabel2.setText(LocalizationData.get("PreferencesDialog.AutoUpdate.forcedCheck.message"));
        jLabel2.setPreferredSize(new Dimension(this.getPreferredSize().height, 100));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridwidth = 4;
        gridBagConstraints4.weighty = 0.0;
        gridBagConstraints4.anchor = 18;
        gridBagConstraints4.insets = new Insets(0, 20, 5, 5);
        gridBagConstraints4.gridy = 2;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 3;
        gridBagConstraints3.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.gridy = 1;
        JLabel jLabel1 = new JLabel();
        jLabel1.setText(LocalizationData.get("PreferencesDialog.AutoUpdate.interval.part2"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 3;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints2.gridx = 2;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.fill = 3;
        gridBagConstraints11.gridx = 1;
        gridBagConstraints11.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints11.gridy = 1;
        JLabel jLabel = new JLabel();
        jLabel.setText(LocalizationData.get("PreferencesDialog.AutoUpdate.interval.part1"));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints1.fill = 0;
        gridBagConstraints1.weighty = 0.0;
        gridBagConstraints1.anchor = 18;
        gridBagConstraints1.gridy = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.gridy = 1;
        this.setSize(378, 200);
        this.setLayout(new GridBagLayout());
        ButtonGroup group = new ButtonGroup();
        this.add((Component)this.getAuto(), gridBagConstraints);
        this.add((Component)this.getManual(), gridBagConstraints1);
        this.add((Component)jLabel, gridBagConstraints11);
        this.add((Component)this.getDays(), gridBagConstraints2);
        this.add((Component)jLabel1, gridBagConstraints3);
        this.add((Component)this.getJPanel(), gridBagConstraints4);
        this.add((Component)jLabel2, gridBagConstraints51);
        group.add(this.getAuto());
        group.add(this.getManual());
        group = new ButtonGroup();
        group.add(this.getAutoInstall());
        group.add(this.getAskMe());
        int period = Preferences.INSTANCE.getAutoUpdatePeriod();
        this.days.setValue(Math.max(0, period));
        (Preferences.INSTANCE.getAutoUpdateInstall() ? this.getAutoInstall() : this.getAskMe()).setSelected(true);
        if (period >= 0) {
            this.getAuto().setSelected(true);
        }
    }

    private void refresh() {
        boolean ok = !this.getManual().isSelected();
        this.getAutoInstall().setEnabled(ok);
        this.getAskMe().setEnabled(ok);
        this.getJPanel().setVisible(ok);
    }

    private JRadioButton getAuto() {
        if (this.auto == null) {
            this.auto = new JRadioButton();
            this.auto.setText(LocalizationData.get("PreferencesDialog.AutoUpdate.atStartup"));
            this.auto.setToolTipText(LocalizationData.get("PreferencesDialog.AutoUpdate.atStartup.toolTip"));
        }
        return this.auto;
    }

    private JRadioButton getManual() {
        if (this.manual == null) {
            this.manual = new JRadioButton();
            this.manual.setText(LocalizationData.get("PreferencesDialog.AutoUpdate.manually"));
            this.manual.setSelected(true);
            this.manual.setToolTipText(LocalizationData.get("PreferencesDialog.AutoUpdate.manually.toolTip"));
            this.manual.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    AutoUpdatePanel.this.refresh();
                }
            });
        }
        return this.manual;
    }

    private IntegerWidget getDays() {
        if (this.days == null) {
            this.days = new IntegerWidget(BigInteger.ZERO, IntegerWidget.INTEGER_MAX_VALUE);
            this.days.setColumns(2);
            this.days.setToolTipText(LocalizationData.get("PreferencesDialog.AutoUpdate.days.toolTip"));
        }
        return this.days;
    }

    @Override
    public String getTitle() {
        return LocalizationData.get("PreferencesDialog.AutoUpdate.title");
    }

    @Override
    public String getToolTip() {
        return LocalizationData.get("PreferencesDialog.AutoUpdate.toolTip");
    }

    @Override
    public boolean updatePreferences() {
        int step = -1;
        if (this.getAuto().isSelected()) {
            if (this.days.getValue() == null) {
                this.days.setValue(0);
            }
            step = this.days.getValue().intValue();
        }
        Preferences.INSTANCE.setAutoUpdate(step, this.getAutoInstall().isSelected());
        return false;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gbcAutoInstall = new GridBagConstraints();
            gbcAutoInstall.fill = 2;
            gbcAutoInstall.gridx = 0;
            gbcAutoInstall.insets = new Insets(5, 5, 0, 5);
            gbcAutoInstall.anchor = 17;
            gbcAutoInstall.gridy = 1;
            GridBagConstraints gbcAskMe = new GridBagConstraints();
            gbcAskMe.fill = 2;
            gbcAskMe.anchor = 17;
            gbcAskMe.gridy = 0;
            gbcAskMe.insets = new Insets(0, 5, 0, 5);
            gbcAskMe.gridx = 0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            TitledBorder border = BorderFactory.createTitledBorder(null, LocalizationData.get("PreferencesDialog.AutoUpdate.ifAvailable.title"));
            this.jPanel.setBorder(border);
            this.jPanel.setEnabled(true);
            JRadioButton btn = this.getAskMe();
            this.jPanel.add((Component)btn, gbcAskMe);
            this.jPanel.add((Component)this.getAutoInstall(), gbcAutoInstall);
            this.jPanel.setVisible(false);
            Dimension d = btn.getPreferredSize();
            if (d.width < border.getMinimumSize((Component)this.jPanel).width) {
                btn.setPreferredSize(new Dimension(border.getMinimumSize((Component)this.jPanel).width, d.height));
            }
        }
        return this.jPanel;
    }

    private JRadioButton getAskMe() {
        if (this.askMe == null) {
            this.askMe = new JRadioButton();
            this.askMe.setText(LocalizationData.get("PreferencesDialog.AutoUpdate.ifAvailable.askMe"));
            this.askMe.setEnabled(false);
        }
        return this.askMe;
    }

    private JRadioButton getAutoInstall() {
        if (this.autoInstall == null) {
            this.autoInstall = new JRadioButton();
            this.autoInstall.setText(LocalizationData.get("PreferencesDialog.AutoUpdate.ifAvailable.autoInstall"));
            this.autoInstall.setEnabled(false);
        }
        return this.autoInstall;
    }
}

