/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.preferences;

import com.fathzer.soft.ajlib.swing.ButtonGroup;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.preferences.EditionWizardSettings;

public class EditionWizardPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JRadioButton alwaysBtn;
    private JLabel lbl;
    private JRadioButton neverBtn;
    private JRadioButton whenEmptyBtn;
    private JLabel lbl2;
    private JRadioButton lastBtn;
    private JRadioButton mostProbableBtn;
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final ButtonGroup buttonGroup1 = new ButtonGroup();
    private JPanel withWhatPanel;

    public EditionWizardPanel() {
        this.initialize();
        this.buttonGroup.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                EditionWizardPanel.this.withWhatPanel.setVisible(!NullUtils.areEquals(arg, EditionWizardPanel.this.getNeverBtn()));
            }
        });
        this.neverBtn.setSelected(true);
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbcNeverBtn = new GridBagConstraints();
        gbcNeverBtn.anchor = 17;
        gbcNeverBtn.insets = new Insets(0, 15, 5, 5);
        gbcNeverBtn.gridx = 0;
        gbcNeverBtn.gridy = 1;
        this.add((Component)this.getNeverBtn(), gbcNeverBtn);
        GridBagConstraints gbcAlwaysBtn = new GridBagConstraints();
        gbcAlwaysBtn.anchor = 17;
        gbcAlwaysBtn.insets = new Insets(0, 15, 5, 5);
        gbcAlwaysBtn.gridx = 0;
        gbcAlwaysBtn.gridy = 2;
        this.add((Component)this.getAlwaysBtn(), gbcAlwaysBtn);
        GridBagConstraints gbcLbl = new GridBagConstraints();
        gbcLbl.insets = new Insets(5, 5, 5, 5);
        gbcLbl.anchor = 17;
        gbcLbl.gridx = 0;
        gbcLbl.gridy = 0;
        this.add((Component)this.getLbl(), gbcLbl);
        GridBagConstraints gbcWithWhatPanel = new GridBagConstraints();
        gbcWithWhatPanel.fill = 1;
        gbcWithWhatPanel.gridheight = 2;
        gbcWithWhatPanel.gridx = 1;
        gbcWithWhatPanel.gridy = 2;
        this.add((Component)this.getWithWhatPanel(), gbcWithWhatPanel);
        GridBagConstraints gbcWhenEmptyBtn = new GridBagConstraints();
        gbcWhenEmptyBtn.insets = new Insets(0, 15, 0, 5);
        gbcWhenEmptyBtn.anchor = 17;
        gbcWhenEmptyBtn.gridx = 0;
        gbcWhenEmptyBtn.gridy = 3;
        this.add((Component)this.getWhenEmptyBtn(), gbcWhenEmptyBtn);
    }

    private JRadioButton getAlwaysBtn() {
        if (this.alwaysBtn == null) {
            this.alwaysBtn = new JRadioButton(LocalizationData.get("TransactionEditingPreferencesPanel.wizard.always"));
            this.buttonGroup.add(this.alwaysBtn);
        }
        return this.alwaysBtn;
    }

    private JLabel getLbl() {
        if (this.lbl == null) {
            this.lbl = new JLabel(LocalizationData.get("TransactionEditingPreferencesPanel.wizard.title"));
        }
        return this.lbl;
    }

    private JRadioButton getNeverBtn() {
        if (this.neverBtn == null) {
            this.neverBtn = new JRadioButton(LocalizationData.get("TransactionEditingPreferencesPanel.wizard.never"));
            this.buttonGroup.add(this.neverBtn);
        }
        return this.neverBtn;
    }

    private JRadioButton getWhenEmptyBtn() {
        if (this.whenEmptyBtn == null) {
            this.whenEmptyBtn = new JRadioButton(LocalizationData.get("TransactionEditingPreferencesPanel.wizard.ifNull"));
            this.buttonGroup.add(this.whenEmptyBtn);
        }
        return this.whenEmptyBtn;
    }

    private JLabel getLbl2() {
        if (this.lbl2 == null) {
            this.lbl2 = new JLabel(LocalizationData.get("TransactionEditingPreferencesPanel.wizard.with"));
        }
        return this.lbl2;
    }

    private JRadioButton getLastBtn() {
        if (this.lastBtn == null) {
            this.lastBtn = new JRadioButton(LocalizationData.get("TransactionEditingPreferencesPanel.wizard.last"));
            this.lastBtn.setToolTipText(LocalizationData.get("TransactionEditingPreferencesPanel.wizard.last.tooltip"));
            this.buttonGroup1.add(this.lastBtn);
        }
        return this.lastBtn;
    }

    private JRadioButton getMostProbableBtn() {
        if (this.mostProbableBtn == null) {
            this.mostProbableBtn = new JRadioButton(LocalizationData.get("TransactionEditingPreferencesPanel.wizard.mostProbable"));
            this.mostProbableBtn.setToolTipText(LocalizationData.get("TransactionEditingPreferencesPanel.wizard.mostProbable.tooltip"));
            this.mostProbableBtn.setSelected(true);
            this.buttonGroup1.add(this.mostProbableBtn);
        }
        return this.mostProbableBtn;
    }

    private JPanel getWithWhatPanel() {
        if (this.withWhatPanel == null) {
            this.withWhatPanel = new JPanel();
            GridBagLayout gblWithWhatPanel = new GridBagLayout();
            this.withWhatPanel.setLayout(gblWithWhatPanel);
            GridBagConstraints gbcLbl2 = new GridBagConstraints();
            gbcLbl2.anchor = 17;
            gbcLbl2.gridheight = 2;
            gbcLbl2.insets = new Insets(0, 0, 0, 5);
            gbcLbl2.gridx = 0;
            gbcLbl2.gridy = 0;
            this.withWhatPanel.add((Component)this.getLbl2(), gbcLbl2);
            GridBagConstraints gbcLastBtn = new GridBagConstraints();
            gbcLastBtn.anchor = 17;
            gbcLastBtn.insets = new Insets(0, 0, 5, 0);
            gbcLastBtn.gridx = 1;
            gbcLastBtn.gridy = 0;
            this.withWhatPanel.add((Component)this.getLastBtn(), gbcLastBtn);
            GridBagConstraints gbcMostProbableBtn = new GridBagConstraints();
            gbcMostProbableBtn.anchor = 17;
            gbcMostProbableBtn.gridx = 1;
            gbcMostProbableBtn.gridy = 1;
            this.withWhatPanel.add((Component)this.getMostProbableBtn(), gbcMostProbableBtn);
        }
        return this.withWhatPanel;
    }

    public EditionWizardSettings getSettings() {
        EditionWizardSettings.Mode mode;
        if (this.getNeverBtn().isSelected()) {
            mode = EditionWizardSettings.Mode.NEVER;
        } else if (this.getAlwaysBtn().isSelected()) {
            mode = EditionWizardSettings.Mode.ALWAYS;
        } else if (this.getWhenEmptyBtn().isSelected()) {
            mode = EditionWizardSettings.Mode.WHEN_NULL;
        } else {
            throw new IllegalStateException();
        }
        EditionWizardSettings.Source source = this.getLastBtn().isSelected() ? EditionWizardSettings.Source.LAST : EditionWizardSettings.Source.MOST_PROBABLE;
        return new EditionWizardSettings(mode, source);
    }

    public void setSettings(EditionWizardSettings settings) {
        EditionWizardSettings.Mode mode = settings.getMode();
        this.getNeverBtn().setSelected(EditionWizardSettings.Mode.NEVER.equals((Object)mode));
        this.getAlwaysBtn().setSelected(EditionWizardSettings.Mode.ALWAYS.equals((Object)mode));
        this.getWhenEmptyBtn().setSelected(EditionWizardSettings.Mode.WHEN_NULL.equals((Object)mode));
        EditionWizardSettings.Source source = settings.getSource();
        this.getLastBtn().setSelected(EditionWizardSettings.Source.LAST.equals((Object)source));
        this.getMostProbableBtn().setSelected(EditionWizardSettings.Source.MOST_PROBABLE.equals((Object)source));
    }
}

