/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.preferences;

import com.fathzer.soft.ajlib.swing.dialog.AbstractDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.MainFrame;
import net.yapbam.gui.dialogs.preferences.AutoUpdatePanel;
import net.yapbam.gui.dialogs.preferences.LocalizationPanel;
import net.yapbam.gui.dialogs.preferences.LookAndFeelPanel;
import net.yapbam.gui.dialogs.preferences.PreferencePanel;
import net.yapbam.gui.dialogs.preferences.ProxyPanel;
import net.yapbam.gui.dialogs.preferences.ReportErrorPanel;
import net.yapbam.gui.dialogs.preferences.RestoreStatePanel;
import net.yapbam.gui.dialogs.preferences.TransactionEditingPanel;
import net.yapbam.gui.util.AutoUpdateOkButtonPropertyListener;
import net.yapbam.util.Portable;

public class PreferenceDialog
extends AbstractDialog<Boolean, Boolean> {
    public static final long LOCALIZATION_CHANGED = 1L;
    public static final long LOOK_AND_FEEL_CHANGED = 2L;
    private List<PreferencePanel> panels;
    private JTabbedPane tabbedPane;

    public PreferenceDialog(MainFrame owner, boolean expertMode) {
        super((Window)owner, LocalizationData.get("PreferencesDialog.title"), Boolean.valueOf(expertMode));
        this.setLocationRelativeTo(owner.getJFrame());
    }

    @Override
    protected Boolean buildResult() {
        boolean result = false;
        for (int i = 0; i < this.panels.size(); ++i) {
            result = this.panels.get(i).updatePreferences() || result;
        }
        return result;
    }

    @Override
    protected JPanel createCenterPane() {
        this.tabbedPane = new JTabbedPane();
        this.panels = new ArrayList<PreferencePanel>();
        MainFrame frame = (MainFrame)this.getOwner();
        this.panels.addAll(Arrays.asList(new LocalizationPanel(), new LookAndFeelPanel(frame), new TransactionEditingPanel(), new ProxyPanel(), new ReportErrorPanel(), new RestoreStatePanel()));
        if (!Portable.isWebStarted()) {
            this.panels.add(new AutoUpdatePanel());
        }
        for (int i = 0; i < frame.getPlugInsNumber(); ++i) {
            PreferencePanel preferencePanel = frame.getPlugIn(i).getPreferencePanel();
            if (preferencePanel == null) continue;
            this.panels.add(preferencePanel);
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){
            private int lastSelected = -1;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (this.lastSelected >= 0) {
                    ((PreferencePanel)PreferenceDialog.this.panels.get(this.lastSelected)).setDisplayed(false);
                }
                this.lastSelected = PreferenceDialog.this.tabbedPane.getSelectedIndex();
                ((PreferencePanel)PreferenceDialog.this.panels.get(this.lastSelected)).setDisplayed(true);
            }
        });
        for (PreferencePanel panel : this.panels) {
            panel.setExpertMode((Boolean)this.data);
            this.tabbedPane.addTab(panel.getTitle(), null, panel, panel.getToolTip());
            panel.addPropertyChangeListener("okDisabledCause", new AutoUpdateOkButtonPropertyListener(this));
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.tabbedPane, "Center");
        return panel;
    }

    @Override
    protected String getOkDisabledCause() {
        String result;
        block1: {
            PreferencePanel panel;
            int selected = this.tabbedPane.getSelectedIndex();
            result = this.panels.get(selected).getOkDisabledCause();
            if (result == null) break block1;
            Iterator<PreferencePanel> iterator = this.panels.iterator();
            while (iterator.hasNext() && (result = (panel = iterator.next()).getOkDisabledCause()) == null) {
            }
        }
        return result;
    }

    public Boolean getChanges() {
        return (Boolean)this.getResult();
    }
}

