/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.filter;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.yapbam.data.Account;
import net.yapbam.data.Category;
import net.yapbam.data.Filter;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Mode;
import net.yapbam.data.comparator.AccountComparator;
import net.yapbam.data.comparator.CategoryComparator;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.filter.AmountPanel;
import net.yapbam.gui.filter.DateFilterPanel;
import net.yapbam.gui.filter.NatureFilterPanel;
import net.yapbam.gui.filter.TextMatcherFilterPanel;
import net.yapbam.util.TextMatcher;

public class CustomFilterPanel
extends JPanel
implements Scrollable {
    private static final long serialVersionUID = 1L;
    public static final String INCONSISTENCY_CAUSE_PROPERTY = "InconsistencyCause";
    private static final String CATEGORY_UNDEFINED_RESOURCE = "Category.undefined";
    private static final String MODE_UNDEFINED_RESOURCE = "Mode.undefined";
    private JPanel accountPanel;
    private JList accountList;
    private AmountPanel amountPanel;
    private JPanel categoryPanel;
    private JList categoryList;
    private TextMatcherFilterPanel descriptionPanel;
    private JPanel statementPanel;
    private JCheckBox checked;
    private JCheckBox notChecked;
    private DateFilterPanel valueDatePanel;
    private JScrollPane jScrollPane;
    private JScrollPane jScrollPane1;
    private TextMatcherFilterPanel jPanel11;
    private JButton clear;
    private JPanel modePanel;
    private JScrollPane jScrollPane2;
    private JList modes;
    private String oldInconsistencyCause;
    private Filter filter;
    private GlobalData gData;
    private ListSelectionListener CONSISTENCY_CHECKER_LIST = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            CustomFilterPanel.this.checkConsistency();
        }
    };
    private TextMatcherFilterPanel numberPanel;
    private NatureFilterPanel receiptsExpensesPanel;
    private JPanel panel;
    private DateFilterPanel datePanel;
    private PropertyChangeListener inconsistencyListener;
    private TextMatcherFilterPanel commentPanel;

    public CustomFilterPanel() {
        this(new Filter(), new GlobalData());
    }

    public CustomFilterPanel(Filter filter, GlobalData data) {
        this.gData = data;
        this.filter = filter;
        this.inconsistencyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CustomFilterPanel.this.checkConsistency();
            }
        };
        this.initialize();
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
        gridBagConstraints28.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints28.gridx = 0;
        gridBagConstraints28.fill = 1;
        gridBagConstraints28.gridy = 2;
        GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
        gridBagConstraints41.anchor = 11;
        gridBagConstraints41.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints41.gridx = 0;
        gridBagConstraints41.fill = 2;
        gridBagConstraints41.weightx = 1.0;
        gridBagConstraints41.gridy = 3;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        GridBagConstraints gbcPanel = new GridBagConstraints();
        gbcPanel.gridheight = 0;
        gbcPanel.gridwidth = 2;
        gbcPanel.weighty = 1.0;
        gbcPanel.weightx = 1.0;
        gbcPanel.fill = 1;
        gbcPanel.gridx = 1;
        gbcPanel.gridy = 0;
        this.add((Component)this.getPanel(), gbcPanel);
        this.add((Component)this.getAccountPanel(), gridBagConstraints);
        GridBagConstraints gbcClear = new GridBagConstraints();
        gbcClear.insets = new Insets(0, 0, 0, 5);
        gbcClear.gridx = 0;
        gbcClear.gridy = 4;
        this.add((Component)this.getClear(), gbcClear);
        this.add((Component)this.getValueDatePanel(), gridBagConstraints41);
        this.add((Component)this.getModePanel(), gridBagConstraints28);
    }

    private JPanel getAccountPanel() {
        if (this.accountPanel == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.fill = 1;
            gridBagConstraints14.weighty = 1.0;
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.gridy = 0;
            gridBagConstraints14.weightx = 1.0;
            this.accountPanel = new JPanel();
            this.accountPanel.setLayout(new GridBagLayout());
            this.accountPanel.setBorder(BorderFactory.createTitledBorder(null, LocalizationData.get("Transaction.account"), 0, 0));
            this.accountPanel.add((Component)this.getJScrollPane(), gridBagConstraints14);
        }
        return this.accountPanel;
    }

    private JList getAccountList() {
        if (this.accountList == null) {
            final Account[] accounts = AccountComparator.getSortedAccounts(this.gData, this.getLocale());
            this.accountList = new JList();
            this.accountList.setModel(new AbstractListModel(){

                @Override
                public Object getElementAt(int index) {
                    return accounts[index].getName();
                }

                @Override
                public int getSize() {
                    return accounts.length;
                }
            });
            this.accountList.setToolTipText(LocalizationData.get("CustomFilterPanel.account.toolTip"));
            ArrayList<Integer> indices = new ArrayList<Integer>(accounts.length);
            for (int i = 0; i < accounts.length; ++i) {
                if (!this.filter.isOk(accounts[i])) continue;
                indices.add(i);
            }
            int[] selection = new int[indices.size()];
            for (int i = 0; i < indices.size(); ++i) {
                selection[i] = (Integer)indices.get(i);
            }
            this.accountList.setSelectedIndices(selection);
            this.updateModesList(true);
            this.accountList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    CustomFilterPanel.this.checkConsistency();
                    CustomFilterPanel.this.updateModesList(false);
                }
            });
            this.accountList.setVisibleRowCount(7);
        }
        return this.accountList;
    }

    private AmountPanel getAmountPanel() {
        if (this.amountPanel == null) {
            this.amountPanel = new AmountPanel();
            this.amountPanel.addPropertyChangeListener(AmountPanel.INCONSISTENCY_CAUSE_PROPERTY, this.inconsistencyListener);
            this.amountPanel.setAmounts(this.filter.getMinAmount(), this.filter.getMaxAmount());
        }
        return this.amountPanel;
    }

    private DateFilterPanel getDatePanel() {
        if (this.datePanel == null) {
            this.datePanel = new DateFilterPanel(DateFilterPanel.TRANSACTION_DATE);
            this.datePanel.addPropertyChangeListener(DateFilterPanel.INCONSISTENCY_CAUSE_PROPERTY, this.inconsistencyListener);
            this.datePanel.setDates(this.filter.getDateFrom(), this.filter.getDateTo());
        }
        return this.datePanel;
    }

    private JPanel getCategoryPanel() {
        if (this.categoryPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            this.categoryPanel = new JPanel();
            this.categoryPanel.setLayout(new GridBagLayout());
            this.categoryPanel.setBorder(BorderFactory.createTitledBorder(null, LocalizationData.get("Transaction.category"), 0, 0));
            this.categoryPanel.add((Component)this.getJScrollPane1(), gridBagConstraints1);
        }
        return this.categoryPanel;
    }

    private JList getCategoryList() {
        if (this.categoryList == null) {
            final Category[] categories = CategoryComparator.getSortedCategories(this.gData, this.getLocale());
            this.categoryList = new JList();
            this.categoryList.setModel(new AbstractListModel(){

                @Override
                public Object getElementAt(int index) {
                    Category category = categories[index];
                    return category.equals(Category.UNDEFINED) ? LocalizationData.get(CustomFilterPanel.CATEGORY_UNDEFINED_RESOURCE) : category.getName();
                }

                @Override
                public int getSize() {
                    return categories.length;
                }
            });
            this.categoryList.setToolTipText(LocalizationData.get("CustomFilterPanel.category.toolTip"));
            ArrayList<Integer> indices = new ArrayList<Integer>(this.gData.getCategoriesNumber());
            for (int i = 0; i < categories.length; ++i) {
                if (!this.filter.isOk(categories[i])) continue;
                indices.add(i);
            }
            int[] selection = new int[indices.size()];
            for (int i = 0; i < indices.size(); ++i) {
                selection[i] = (Integer)indices.get(i);
            }
            this.categoryList.setSelectedIndices(selection);
            this.categoryList.addListSelectionListener(this.CONSISTENCY_CHECKER_LIST);
        }
        return this.categoryList;
    }

    private void updateModesList(boolean first) {
        int i;
        String[] currentSelectedModes = null;
        if (!first) {
            int[] selectedIndices = this.getModes().getSelectedIndices();
            currentSelectedModes = new String[selectedIndices.length];
            for (int i2 = 0; i2 < currentSelectedModes.length; ++i2) {
                currentSelectedModes[i2] = (String)this.getModes().getModel().getElementAt(selectedIndices[i2]);
            }
        }
        Object[] accountNames = this.accountList.getSelectedValues();
        TreeSet<String> modes = new TreeSet<String>();
        for (int i3 = 0; i3 < accountNames.length; ++i3) {
            Account account = this.gData.getAccount((String)accountNames[i3]);
            int nb = account.getModesNumber();
            for (int j = 0; j < nb; ++j) {
                Mode mode = account.getMode(j);
                modes.add(mode.equals(Mode.UNDEFINED) ? LocalizationData.get(MODE_UNDEFINED_RESOURCE) : mode.getName());
            }
        }
        Object[] arrayModes = modes.toArray(new String[modes.size()]);
        this.getModes().setModel(new AbstractListModel((String[])arrayModes){
            final /* synthetic */ String[] val$arrayModes;
            {
                this.val$arrayModes = stringArray;
            }

            @Override
            public int getSize() {
                return this.val$arrayModes.length;
            }

            @Override
            public Object getElementAt(int index) {
                return this.val$arrayModes[index];
            }
        });
        ArrayList<Integer> newSelection = new ArrayList<Integer>();
        if (first) {
            List<String> validModes = this.filter.getValidModes();
            if (validModes != null) {
                for (i = 0; i < validModes.size(); ++i) {
                    int index;
                    String name = validModes.get(i);
                    if (name.isEmpty()) {
                        name = LocalizationData.get(MODE_UNDEFINED_RESOURCE);
                    }
                    if ((index = Arrays.binarySearch(arrayModes, name)) < 0) continue;
                    newSelection.add(index);
                }
            } else {
                for (i = 0; i < arrayModes.length; ++i) {
                    newSelection.add(i);
                }
            }
        } else {
            for (int i4 = 0; i4 < currentSelectedModes.length; ++i4) {
                int index = Arrays.binarySearch(arrayModes, currentSelectedModes[i4]);
                if (index < 0) continue;
                newSelection.add(index);
            }
        }
        int[] indices = new int[newSelection.size()];
        for (i = 0; i < indices.length; ++i) {
            indices[i] = (Integer)newSelection.get(i);
        }
        this.getModes().setSelectedIndices(indices);
    }

    public boolean apply() {
        return this.apply(this.filter);
    }

    public boolean apply(Filter filter) {
        filter.setSuspended(true);
        Object[] selectedModes = this.getModes().getSelectedValues();
        ArrayList<String> modes = new ArrayList<String>();
        boolean all = true;
        Object[] accountNames = this.accountList.getSelectedValues();
        Account[] accounts = new Account[accountNames.length];
        for (int i = 0; i < accounts.length; ++i) {
            accounts[i] = this.gData.getAccount((String)accountNames[i]);
            for (int j = 0; j < accounts[i].getModesNumber(); ++j) {
                Mode mode = accounts[i].getMode(j);
                if (Arrays.binarySearch(selectedModes, mode.equals(Mode.UNDEFINED) ? LocalizationData.get(MODE_UNDEFINED_RESOURCE) : mode.getName()) < 0) {
                    all = false;
                    continue;
                }
                modes.add(mode.equals(Mode.UNDEFINED) ? "" : mode.getName());
            }
        }
        filter.setValidAccounts(accounts.length == this.gData.getAccountsNumber() ? null : Arrays.asList(accounts));
        filter.setValidModes(all ? null : modes);
        Object[] categoryNames = this.categoryList.getSelectedValues();
        if (categoryNames.length == this.gData.getCategoriesNumber()) {
            filter.setValidCategories(null);
        } else {
            ArrayList<Category> categories = new ArrayList<Category>(categoryNames.length);
            String undefinedCategoryName = LocalizationData.get(CATEGORY_UNDEFINED_RESOURCE);
            for (int i = 0; i < categoryNames.length; ++i) {
                String name = (String)categoryNames[i];
                categories.add(undefinedCategoryName.equals(categoryNames[i]) ? Category.UNDEFINED : this.gData.getCategory(name));
            }
            filter.setValidCategories(categories);
        }
        Double min = this.getAmountPanel().getMinAmount();
        Double max = this.getAmountPanel().getMaxAmount();
        int mask = 0;
        if (this.getReceiptsExpensesPanel().isReceiptsSelected()) {
            mask += 8;
        }
        if (this.getReceiptsExpensesPanel().isExpensesSelected()) {
            mask += 4;
        }
        filter.setAmountFilter(mask, min, max);
        filter.setDateFilter(this.getDatePanel().getDateFrom(), this.getDatePanel().getDateTo());
        filter.setValueDateFilter(this.getValueDatePanel().getDateFrom(), this.getValueDatePanel().getDateTo());
        filter.setDescriptionMatcher(this.getDescriptionPanel().getTextMatcher());
        filter.setCommentMatcher(this.getCommentPanel().getTextMatcher());
        mask = 0;
        TextMatcher statementFilter = null;
        if (this.getChecked().isSelected()) {
            ++mask;
            statementFilter = this.getJPanel11().getTextMatcher();
        }
        if (this.getNotChecked().isSelected()) {
            mask += 2;
        }
        filter.setStatementFilter(mask, statementFilter);
        filter.setNumberMatcher(this.getNumberPanel().getTextMatcher());
        boolean result = filter.hasChanged();
        filter.setSuspended(false);
        return result;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getAccountList());
        }
        return this.jScrollPane;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getCategoryList());
        }
        return this.jScrollPane1;
    }

    public String getInconsistencyCause() {
        if (this.getDescriptionPanel().getInconsistencyCause() != null) {
            return this.getDescriptionPanel().getInconsistencyCause();
        }
        if (this.getCommentPanel().getInconsistencyCause() != null) {
            return this.getCommentPanel().getInconsistencyCause();
        }
        if (this.getNumberPanel().getInconsistencyCause() != null) {
            return this.getNumberPanel().getInconsistencyCause();
        }
        if (this.getJPanel11().getInconsistencyCause() != null) {
            return this.getJPanel11().getInconsistencyCause();
        }
        if (this.getReceiptsExpensesPanel().getInconsistencyCause() != null) {
            return this.getReceiptsExpensesPanel().getInconsistencyCause();
        }
        if (!this.getChecked().isSelected() && !this.getNotChecked().isSelected()) {
            return Formatter.format(LocalizationData.get("CustomFilterPanel.error.checkStatus"), LocalizationData.get("MainMenuBar.checked"), LocalizationData.get("MainMenuBar.notChecked"));
        }
        if (this.getValueDatePanel().getInconsistencyCause() != null) {
            return this.getValueDatePanel().getInconsistencyCause();
        }
        if (this.getAmountPanel().getInconsistencyCause() != null) {
            return this.getAmountPanel().getInconsistencyCause();
        }
        if (this.getDatePanel().getInconsistencyCause() != null) {
            return this.getDatePanel().getInconsistencyCause();
        }
        if (this.getAccountList().getSelectedIndices().length == 0) {
            return LocalizationData.get("CustomFilterPanel.error.noAccount");
        }
        if (this.getModes().getSelectedIndices().length == 0) {
            return LocalizationData.get("CustomFilterPanel.error.noMode");
        }
        if (this.getCategoryList().getSelectedIndices().length == 0) {
            return LocalizationData.get("CustomFilterPanel.error.noCategory");
        }
        return null;
    }

    public boolean isConsistent() {
        return this.getInconsistencyCause() != null;
    }

    private void checkConsistency() {
        String cause = this.getInconsistencyCause();
        if (!NullUtils.areEquals(cause, this.oldInconsistencyCause)) {
            this.firePropertyChange(INCONSISTENCY_CAUSE_PROPERTY, this.oldInconsistencyCause, cause);
            this.oldInconsistencyCause = cause;
        }
    }

    private TextMatcherFilterPanel getDescriptionPanel() {
        if (this.descriptionPanel == null) {
            this.descriptionPanel = new TextMatcherFilterPanel(TextMatcherFilterPanel.DESCRIPTION_WORDING);
            this.descriptionPanel.addPropertyChangeListener(TextMatcherFilterPanel.INCONSISTENCY_CAUSE_PROPERTY, this.inconsistencyListener);
            this.descriptionPanel.setTextMatcher(this.filter.getDescriptionMatcher());
        }
        return this.descriptionPanel;
    }

    private JPanel getStatementPanel() {
        if (this.statementPanel == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridwidth = 0;
            gridBagConstraints6.gridy = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.gridheight = 0;
            gridBagConstraints5.gridx = 2;
            GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
            gridBagConstraints27.gridx = 2;
            gridBagConstraints27.anchor = 17;
            gridBagConstraints27.fill = 2;
            gridBagConstraints27.weightx = 1.0;
            gridBagConstraints27.gridy = 0;
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.gridx = 0;
            gridBagConstraints26.anchor = 17;
            gridBagConstraints26.gridy = 0;
            this.statementPanel = new JPanel();
            this.statementPanel.setLayout(new GridBagLayout());
            this.statementPanel.setBorder(BorderFactory.createTitledBorder(null, LocalizationData.get("CustomFilterPanel.check"), 0, 0));
            this.statementPanel.add((Component)this.getChecked(), gridBagConstraints26);
            this.statementPanel.add((Component)this.getNotChecked(), gridBagConstraints27);
            this.statementPanel.add((Component)this.getJPanel11(), gridBagConstraints6);
        }
        return this.statementPanel;
    }

    private JCheckBox getChecked() {
        if (this.checked == null) {
            this.checked = new JCheckBox();
            this.checked.setText(LocalizationData.get("MainMenuBar.checked"));
            this.checked.setToolTipText(LocalizationData.get("CustomFilterPanel.checked.toolTip"));
            this.checked.setSelected(this.filter.isOk(1));
            this.setStatementFilterEnabled();
            this.checked.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CustomFilterPanel.this.checkConsistency();
                    CustomFilterPanel.this.setStatementFilterEnabled();
                }
            });
        }
        return this.checked;
    }

    private void setStatementFilterEnabled() {
        this.getJPanel11().setEnabled(this.checked.isSelected());
    }

    private JCheckBox getNotChecked() {
        if (this.notChecked == null) {
            this.notChecked = new JCheckBox();
            this.notChecked.setText(LocalizationData.get("MainMenuBar.notChecked"));
            this.notChecked.setToolTipText(LocalizationData.get("CustomFilterPanel.unchecked.toolTip"));
            this.notChecked.setSelected(this.filter.isOk(2));
            this.notChecked.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CustomFilterPanel.this.checkConsistency();
                }
            });
        }
        return this.notChecked;
    }

    private DateFilterPanel getValueDatePanel() {
        if (this.valueDatePanel == null) {
            this.valueDatePanel = new DateFilterPanel(DateFilterPanel.VALUE_DATE);
            this.valueDatePanel.addPropertyChangeListener(DateFilterPanel.INCONSISTENCY_CAUSE_PROPERTY, this.inconsistencyListener);
            this.valueDatePanel.setDates(this.filter.getValueDateFrom(), this.filter.getValueDateTo());
        }
        return this.valueDatePanel;
    }

    private TextMatcherFilterPanel getJPanel11() {
        if (this.jPanel11 == null) {
            this.jPanel11 = new TextMatcherFilterPanel(TextMatcherFilterPanel.STATEMENT_WORDING);
            if (this.getChecked().isSelected()) {
                this.jPanel11.setTextMatcher(this.filter.getStatementMatcher());
                this.jPanel11.addPropertyChangeListener(TextMatcherFilterPanel.INCONSISTENCY_CAUSE_PROPERTY, this.inconsistencyListener);
                this.jPanel11.setCheckBoxesVisible(false);
            }
        }
        return this.jPanel11;
    }

    private JButton getClear() {
        if (this.clear == null) {
            this.clear = new JButton();
            this.clear.setText(LocalizationData.get("CustomFilterPanel.clearAll"));
            this.clear.setToolTipText(LocalizationData.get("CustomFilterPanel.clearAll.toolTip"));
            this.clear.setEnabled(true);
            this.clear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomFilterPanel.this.clear();
                }
            });
        }
        return this.clear;
    }

    private void clear() {
        this.selectAll(this.getAccountList());
        this.selectAll(this.getModes());
        this.selectAll(this.getCategoryList());
        this.getDescriptionPanel().clear();
        this.getCommentPanel().clear();
        this.getReceiptsExpensesPanel().clear();
        this.getAmountPanel().clear();
        this.getDatePanel().clear();
        this.getNumberPanel().clear();
        this.getValueDatePanel().clear();
        this.getChecked().setSelected(true);
        this.getNotChecked().setSelected(true);
        this.getJPanel11().clear();
    }

    private void selectAll(JList list) {
        list.getSelectionModel().addSelectionInterval(0, list.getModel().getSize() - 1);
    }

    private JPanel getModePanel() {
        if (this.modePanel == null) {
            GridBagConstraints gridBagConstraints37 = new GridBagConstraints();
            gridBagConstraints37.fill = 1;
            gridBagConstraints37.gridy = 0;
            gridBagConstraints37.weightx = 1.0;
            gridBagConstraints37.weighty = 1.0;
            gridBagConstraints37.gridx = 0;
            this.modePanel = new JPanel();
            this.modePanel.setLayout(new GridBagLayout());
            this.modePanel.setBorder(BorderFactory.createTitledBorder(null, LocalizationData.get("Transaction.mode"), 0, 0));
            this.modePanel.add((Component)this.getJScrollPane2(), gridBagConstraints37);
        }
        return this.modePanel;
    }

    private JScrollPane getJScrollPane2() {
        if (this.jScrollPane2 == null) {
            this.jScrollPane2 = new JScrollPane();
            this.jScrollPane2.setToolTipText("");
            this.jScrollPane2.setViewportView(this.getModes());
        }
        return this.jScrollPane2;
    }

    private JList getModes() {
        if (this.modes == null) {
            this.modes = new JList();
            this.modes.setToolTipText(LocalizationData.get("CustomFilterPanel.mode.toolTip"));
            this.modes.addListSelectionListener(this.CONSISTENCY_CHECKER_LIST);
            this.modes.setVisibleRowCount(7);
        }
        return this.modes;
    }

    private TextMatcherFilterPanel getNumberPanel() {
        if (this.numberPanel == null) {
            this.numberPanel = new TextMatcherFilterPanel(TextMatcherFilterPanel.NUMBER_WORDING);
            this.numberPanel.addPropertyChangeListener(TextMatcherFilterPanel.INCONSISTENCY_CAUSE_PROPERTY, this.inconsistencyListener);
            this.numberPanel.setTextMatcher(this.filter.getNumberMatcher());
            this.numberPanel.setCheckBoxesVisible(false);
        }
        return this.numberPanel;
    }

    private NatureFilterPanel getReceiptsExpensesPanel() {
        if (this.receiptsExpensesPanel == null) {
            this.receiptsExpensesPanel = new NatureFilterPanel();
            this.receiptsExpensesPanel.addPropertyChangeListener(this.inconsistencyListener);
            this.receiptsExpensesPanel.setSelected(this.filter.isOk(8), this.filter.isOk(4));
        }
        return this.receiptsExpensesPanel;
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            GridBagLayout gblPanel = new GridBagLayout();
            this.panel.setLayout(gblPanel);
            GridBagConstraints gbcCommentPanel = new GridBagConstraints();
            gbcCommentPanel.weightx = 1.0;
            gbcCommentPanel.fill = 2;
            gbcCommentPanel.gridwidth = 2;
            gbcCommentPanel.insets = new Insets(0, 0, 5, 5);
            gbcCommentPanel.gridx = 0;
            gbcCommentPanel.gridy = 1;
            this.panel.add((Component)this.getCommentPanel(), gbcCommentPanel);
            GridBagConstraints gbcAmountPanel = new GridBagConstraints();
            gbcAmountPanel.fill = 2;
            gbcAmountPanel.insets = new Insets(0, 0, 5, 5);
            gbcAmountPanel.gridx = 0;
            gbcAmountPanel.gridy = 3;
            this.panel.add((Component)this.getAmountPanel(), gbcAmountPanel);
            GridBagConstraints gbcReceiptsExpensesPanel = new GridBagConstraints();
            gbcReceiptsExpensesPanel.insets = new Insets(0, 0, 5, 5);
            gbcReceiptsExpensesPanel.weightx = 1.0;
            gbcReceiptsExpensesPanel.anchor = 11;
            gbcReceiptsExpensesPanel.fill = 2;
            gbcReceiptsExpensesPanel.gridx = 0;
            gbcReceiptsExpensesPanel.gridy = 2;
            this.panel.add((Component)this.getReceiptsExpensesPanel(), gbcReceiptsExpensesPanel);
            GridBagConstraints gbcDescriptionPanel = new GridBagConstraints();
            gbcDescriptionPanel.gridwidth = 2;
            gbcDescriptionPanel.insets = new Insets(0, 0, 5, 0);
            gbcDescriptionPanel.weightx = 1.0;
            gbcDescriptionPanel.fill = 2;
            gbcDescriptionPanel.gridx = 0;
            gbcDescriptionPanel.gridy = 0;
            this.panel.add((Component)this.getDescriptionPanel(), gbcDescriptionPanel);
            GridBagConstraints gbcCategoryPanel = new GridBagConstraints();
            gbcCategoryPanel.fill = 1;
            gbcCategoryPanel.gridheight = 4;
            gbcCategoryPanel.insets = new Insets(0, 0, 5, 0);
            gbcCategoryPanel.gridx = 1;
            gbcCategoryPanel.gridy = 2;
            this.panel.add((Component)this.getCategoryPanel(), gbcCategoryPanel);
            GridBagConstraints gbcNumberPanel = new GridBagConstraints();
            gbcNumberPanel.fill = 2;
            gbcNumberPanel.insets = new Insets(0, 0, 5, 5);
            gbcNumberPanel.gridx = 0;
            gbcNumberPanel.gridy = 4;
            this.panel.add((Component)this.getNumberPanel(), gbcNumberPanel);
            GridBagConstraints gbcStatementPanel = new GridBagConstraints();
            gbcStatementPanel.insets = new Insets(0, 0, 5, 5);
            gbcStatementPanel.anchor = 11;
            gbcStatementPanel.fill = 2;
            gbcStatementPanel.gridx = 0;
            gbcStatementPanel.gridy = 5;
            this.panel.add((Component)this.getStatementPanel(), gbcStatementPanel);
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.fill = 2;
            gridBagConstraints21.weightx = 1.0;
            gridBagConstraints21.gridy = 1;
            this.add((Component)this.getDatePanel(), gridBagConstraints21);
        }
        return this.panel;
    }

    private TextMatcherFilterPanel getCommentPanel() {
        if (this.commentPanel == null) {
            this.commentPanel = new TextMatcherFilterPanel(TextMatcherFilterPanel.COMMENT_WORDING);
            this.commentPanel.addPropertyChangeListener(TextMatcherFilterPanel.INCONSISTENCY_CAUSE_PROPERTY, this.inconsistencyListener);
            this.commentPanel.setTextMatcher(this.filter.getCommentMatcher());
        }
        return this.commentPanel;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 40;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public GlobalData getData() {
        return this.gData;
    }
}

