/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.filter;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.widget.TextWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.yapbam.data.Filter;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.filter.CustomFilterPanel;

public class SavePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String NAME_FIELD_TOOLTIP = LocalizationData.get("CustomFilterPanel.save.nameField.tooltip");
    private static final String SAVE_BUTTON_NAME = LocalizationData.get("CustomFilterPanel.save.saveButton.title");
    private static final String SAVE_BUTTON_ENABLED_TOOLTIP = LocalizationData.get("CustomFilterPanel.save.saveButton.tooltip");
    private static final String SAVE_BUTTON_DISABLED_TOOLTIP = LocalizationData.get("CustomFilterPanel.save.saveButton.disabled.tooltip");
    private CustomFilterPanel filterPanel;
    private TextWidget textField;
    private JButton btnSave;

    public SavePanel() {
        this((CustomFilterPanel)null);
    }

    public SavePanel(CustomFilterPanel filterPanel) {
        this.filterPanel = filterPanel;
        this.add(new JLabel(LocalizationData.get("CustomFilterPanel.error.filterNameField.title")));
        this.add(this.getNameField());
        this.add(this.getSaveBtn());
    }

    private TextWidget getNameField() {
        if (this.textField == null) {
            this.textField = new TextWidget();
            this.textField.setColumns(10);
            this.textField.setToolTipText(Formatter.format(NAME_FIELD_TOOLTIP, SAVE_BUTTON_NAME));
            this.textField.addPropertyChangeListener("text", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean isOk = this.isValidName(SavePanel.this.textField.getText());
                    SavePanel.this.getSaveBtn().setEnabled(isOk);
                    SavePanel.this.getSaveBtn().setToolTipText(isOk ? SAVE_BUTTON_ENABLED_TOOLTIP : SAVE_BUTTON_DISABLED_TOOLTIP);
                }

                private boolean isValidName(String text) {
                    return !text.isEmpty();
                }
            });
        }
        return this.textField;
    }

    private JButton getSaveBtn() {
        if (this.btnSave == null) {
            this.btnSave = new JButton(SAVE_BUTTON_NAME);
            this.btnSave.setToolTipText(SAVE_BUTTON_DISABLED_TOOLTIP);
            this.btnSave.setEnabled(false);
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SavePanel.this.doSave();
                }
            });
        }
        return this.btnSave;
    }

    private void doSave() {
        String name = this.getNameField().getText();
        if (!name.equals(this.filterPanel.getFilter().getName())) {
            boolean newOne;
            Filter editedFilter = this.filterPanel.getData().getFilter(name);
            boolean bl = newOne = editedFilter == null;
            if (newOne) {
                editedFilter = new Filter();
                editedFilter.setName(name);
            } else if (JOptionPane.showConfirmDialog(this, LocalizationData.get("CustomFilterPanel.save.overwrite.question"), null, 0) != 0) {
                return;
            }
            this.filterPanel.apply(editedFilter);
            if (newOne) {
                this.filterPanel.getData().add(editedFilter);
            } else {
                this.filterPanel.getData().getFilter(name).copy(editedFilter);
            }
        }
    }
}

