/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.filter;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.widget.TextWidget;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.yapbam.gui.HelpManager;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.filter.ConsistencyCheckedPanel;
import net.yapbam.gui.widget.AutoSelectFocusListener;
import net.yapbam.util.TextMatcher;

public class TextMatcherFilterPanel
extends ConsistencyCheckedPanel {
    private static final long serialVersionUID = 1L;
    public static final Wordings DESCRIPTION_WORDING = new Wordings(LocalizationData.get("Transaction.description"), LocalizationData.get("CustomFilterPanel.description.equals.toolTip"), LocalizationData.get("CustomFilterPanel.description.contains.toolTip"), LocalizationData.get("CustomFilterPanel.description.regularExpression.toolTip"), LocalizationData.get("CustomFilterPanel.description.toolTip"));
    public static final Wordings COMMENT_WORDING = new Wordings(LocalizationData.get("Transaction.comment"), LocalizationData.get("CustomFilterPanel.comment.equals.toolTip"), LocalizationData.get("CustomFilterPanel.comment.contains.toolTip"), LocalizationData.get("CustomFilterPanel.comment.regularExpression.toolTip"), LocalizationData.get("CustomFilterPanel.comment.toolTip"));
    public static final Wordings NUMBER_WORDING = new Wordings(LocalizationData.get("Transaction.number"), LocalizationData.get("CustomFilterPanel.number.equals.toolTip"), LocalizationData.get("CustomFilterPanel.number.contains.toolTip"), LocalizationData.get("CustomFilterPanel.number.regularExpression.toolTip"), LocalizationData.get("CustomFilterPanel.number.toolTip"));
    public static final Wordings STATEMENT_WORDING = new Wordings(LocalizationData.get("Transaction.statement"), LocalizationData.get("CustomFilterPanel.statement.equals.toolTip"), LocalizationData.get("CustomFilterPanel.statement.contains.toolTip"), LocalizationData.get("CustomFilterPanel.statement.regularExpression.toolTip"), LocalizationData.get("CustomFilterPanel.statement.toolTip"));
    private Wordings wordings;
    private JPanel jPanel1;
    private JRadioButton descriptionEqualsTo;
    private JRadioButton descriptionContains;
    private JRadioButton descriptionRegular;
    private JPanel jPanel2;
    private JCheckBox ignoreDiacritics;
    private JCheckBox ignoreCase;
    private JTextField description;
    private JPanel panel;

    public TextMatcherFilterPanel(Wordings wordings) {
        this.wordings = wordings;
        this.setBorder(BorderFactory.createTitledBorder(null, wordings.title, 0, 0));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbcPanel = new GridBagConstraints();
        gbcPanel.weighty = 1.0;
        gbcPanel.weightx = 1.0;
        gbcPanel.fill = 1;
        gbcPanel.gridx = 0;
        gbcPanel.gridy = 0;
        this.add((Component)this.getPanel(), gbcPanel);
    }

    public TextMatcher getTextMatcher() {
        String text = this.getDescription().getText().trim();
        if (text.length() == 0) {
            return null;
        }
        TextMatcher.Kind kind = null;
        if (this.getDescriptionEqualsTo().isSelected()) {
            kind = TextMatcher.Kind.EQUALS;
        } else if (this.getDescriptionContains().isSelected()) {
            kind = TextMatcher.Kind.CONTAINS;
        } else if (this.getDescriptionRegular().isSelected()) {
            kind = TextMatcher.Kind.REGULAR;
        }
        return new TextMatcher(kind, text, !this.getIgnoreCase().isSelected(), !this.getIgnoreDiacritics().isSelected());
    }

    public void clear() {
        this.getDescriptionContains().setSelected(true);
        this.getDescription().setText("");
    }

    public void setTextMatcher(TextMatcher tMatcher) {
        if (tMatcher == null || tMatcher.getKind() == TextMatcher.Kind.CONTAINS) {
            this.getDescriptionContains().setSelected(true);
        } else if (tMatcher.getKind() == TextMatcher.Kind.EQUALS) {
            this.getDescriptionEqualsTo().setSelected(true);
        } else {
            this.getDescriptionRegular().setSelected(true);
        }
        this.ignoreDiacritics.setSelected(tMatcher == null || !tMatcher.isDiacriticalSensitive());
        this.ignoreCase.setSelected(tMatcher == null || !tMatcher.isCaseSensitive());
        this.description.setText(tMatcher == null ? "" : tMatcher.getFilter());
    }

    public void setCheckBoxesVisible(boolean visible) {
        this.getIgnoreCase().setVisible(visible);
        this.ignoreDiacritics.setVisible(visible);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getDescriptionContains().setEnabled(enabled);
        this.getDescriptionEqualsTo().setEnabled(enabled);
        this.getDescriptionRegular().setEnabled(enabled);
        this.getDescription().setEnabled(enabled);
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints36 = new GridBagConstraints();
            gridBagConstraints36.gridx = 0;
            gridBagConstraints36.gridy = 2;
            GridBagConstraints gridBagConstraints35 = new GridBagConstraints();
            gridBagConstraints35.gridx = 0;
            gridBagConstraints35.anchor = 17;
            gridBagConstraints35.gridheight = 1;
            gridBagConstraints35.gridwidth = 1;
            gridBagConstraints35.weightx = 0.0;
            gridBagConstraints35.gridy = 1;
            GridBagConstraints gridBagConstraints34 = new GridBagConstraints();
            gridBagConstraints34.gridx = 0;
            gridBagConstraints34.anchor = 17;
            gridBagConstraints34.gridy = 0;
            GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
            gridBagConstraints32.anchor = 17;
            gridBagConstraints32.gridy = 2;
            gridBagConstraints32.weightx = 1.0;
            gridBagConstraints32.gridx = 1;
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            JLabel regexpHelp = new JLabel();
            regexpHelp.setToolTipText(LocalizationData.get("CustomFilterPanel.regexprHelp.toolTip"));
            regexpHelp.setIcon(IconManager.get(IconManager.Name.HELP));
            regexpHelp.addMouseListener(new RegexprListener());
            this.jPanel1.add((Component)regexpHelp, gridBagConstraints32);
            this.jPanel1.add((Component)this.getDescriptionEqualsTo(), gridBagConstraints34);
            this.jPanel1.add((Component)this.getDescriptionContains(), gridBagConstraints35);
            this.jPanel1.add((Component)this.getDescriptionRegular(), gridBagConstraints36);
            ButtonGroup group = new ButtonGroup();
            group.add(this.getDescriptionEqualsTo());
            group.add(this.getDescriptionContains());
            group.add(this.getDescriptionRegular());
        }
        return this.jPanel1;
    }

    private JRadioButton getDescriptionEqualsTo() {
        if (this.descriptionEqualsTo == null) {
            this.descriptionEqualsTo = new JRadioButton();
            this.descriptionEqualsTo.setText(LocalizationData.get("CustomFilterPanel.description.equals"));
            this.descriptionEqualsTo.setToolTipText(this.wordings.equalsToolTip);
        }
        return this.descriptionEqualsTo;
    }

    private JRadioButton getDescriptionContains() {
        if (this.descriptionContains == null) {
            this.descriptionContains = new JRadioButton();
            this.descriptionContains.setSelected(true);
            this.descriptionContains.setText(LocalizationData.get("CustomFilterPanel.description.contains"));
            this.descriptionContains.setToolTipText(this.wordings.containsToolTip);
        }
        return this.descriptionContains;
    }

    private JRadioButton getDescriptionRegular() {
        if (this.descriptionRegular == null) {
            this.descriptionRegular = new JRadioButton();
            this.descriptionRegular.setText(LocalizationData.get("CustomFilterPanel.description.regularExpression"));
            this.descriptionRegular.setToolTipText(this.wordings.regExprToolTip);
            this.descriptionRegular.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TextMatcherFilterPanel.this.checkConsistency();
                }
            });
        }
        return this.descriptionRegular;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.anchor = 11;
            gridBagConstraints18.gridwidth = 0;
            gridBagConstraints18.gridx = 0;
            gridBagConstraints18.gridy = 1;
            gridBagConstraints18.weightx = 1.0;
            gridBagConstraints18.fill = 2;
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.anchor = 17;
            gridBagConstraints17.gridy = 0;
            gridBagConstraints17.gridx = 1;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 0;
            gridBagConstraints16.anchor = 17;
            gridBagConstraints16.gridy = -1;
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new GridBagLayout());
            this.jPanel2.add((Component)this.getIgnoreCase(), gridBagConstraints16);
            this.jPanel2.add((Component)this.getIgnoreDiacritics(), gridBagConstraints17);
            this.jPanel2.add((Component)this.getDescription(), gridBagConstraints18);
        }
        return this.jPanel2;
    }

    private JCheckBox getIgnoreCase() {
        if (this.ignoreCase == null) {
            this.ignoreCase = new JCheckBox();
            this.ignoreCase.setText(LocalizationData.get("CustomFilterPanel.description.ignoreCase"));
            this.ignoreCase.setToolTipText(LocalizationData.get("CustomFilterPanel.description.ignoreCase.toolTip"));
        }
        return this.ignoreCase;
    }

    private JTextField getDescription() {
        if (this.description == null) {
            this.description = new TextWidget();
            this.description.setToolTipText(this.wordings.descriptionToolTip);
            this.description.addFocusListener(AutoSelectFocusListener.INSTANCE);
            this.description.addPropertyChangeListener("text", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    TextMatcherFilterPanel.this.checkConsistency();
                }
            });
        }
        return this.description;
    }

    private JCheckBox getIgnoreDiacritics() {
        if (this.ignoreDiacritics == null) {
            this.ignoreDiacritics = new JCheckBox();
            this.ignoreDiacritics.setText(LocalizationData.get("CustomFilterPanel.description.ignoreDiacriticals"));
            this.ignoreDiacritics.setToolTipText(LocalizationData.get("CustomFilterPanel.description.ignoreDiacriticals.toolTip"));
        }
        return this.ignoreDiacritics;
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            GridBagLayout gblPanel = new GridBagLayout();
            this.panel.setLayout(gblPanel);
            GridBagConstraints gbcJPanel1 = new GridBagConstraints();
            gbcJPanel1.anchor = 18;
            gbcJPanel1.insets = new Insets(0, 0, 0, 5);
            gbcJPanel1.gridx = 0;
            gbcJPanel1.gridy = 0;
            this.panel.add((Component)this.getJPanel1(), gbcJPanel1);
            GridBagConstraints gbcJPanel2 = new GridBagConstraints();
            gbcJPanel2.weightx = 1.0;
            gbcJPanel2.fill = 2;
            gbcJPanel2.gridx = 1;
            gbcJPanel2.gridy = 0;
            this.panel.add((Component)this.getJPanel2(), gbcJPanel2);
        }
        return this.panel;
    }

    @Override
    protected String computeInconsistencyCause() {
        if (!this.getDescriptionRegular().isSelected()) {
            return null;
        }
        String text = this.getDescription().getText();
        try {
            Pattern.compile(text);
            return null;
        }
        catch (PatternSyntaxException e) {
            return Formatter.format(LocalizationData.get("TextMatcherFilterPanel.invalidRegularExpression"), text);
        }
    }

    private static final class RegexprListener
    extends MouseAdapter {
        private RegexprListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            HelpManager.show(e.getComponent(), HelpManager.REGULAR_EXPRESSIONS);
        }
    }

    public static class Wordings {
        private String title;
        private String equalsToolTip;
        private String containsToolTip;
        private String regExprToolTip;
        private String descriptionToolTip;

        public Wordings(String title, String equalsToolTip, String containsToolTip, String regExprToolTip, String descriptionToolTip) {
            this.title = title;
            this.equalsToolTip = equalsToolTip;
            this.containsToolTip = containsToolTip;
            this.regExprToolTip = regExprToolTip;
            this.descriptionToolTip = descriptionToolTip;
        }
    }
}

