/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.graphics.balancehistory;

import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormatSymbols;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import net.yapbam.data.BalanceHistory;
import net.yapbam.data.BalanceHistoryElement;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.graphics.balancehistory.Graduation;
import net.yapbam.gui.graphics.balancehistory.YAxis;

class BalanceGraphic
extends JPanel
implements Scrollable {
    static final String SELECTED_DATE_PROPERTY = "selectedDate";
    private static final long serialVersionUID = 1L;
    private static final int X_OFFSET = 0;
    private static final Color POSITIVE = new Color(127, 255, 127);
    private static final Color NEGATIVE = new Color(255, 127, 127);
    private BalanceHistory balanceHistory;
    private boolean needUpdate;
    private Date startDate;
    private Date endDate;
    private YAxis yAxis;
    private int zoomLevel;
    private int pixelPerDay;
    private Date selectedDate;
    private Point[] points;
    private boolean gridIsVisible;
    private Date preferredEndDate;
    private static final double MILLIS_PER_DAY = 8.64E7;

    private BalanceGraphic() {
        this(new BalanceHistory(0.0), new YAxis(new JLabel()));
    }

    BalanceGraphic(BalanceHistory history, YAxis yAxis) {
        if (history == null || yAxis == null) {
            throw new NullPointerException();
        }
        this.selectedDate = new Date();
        this.balanceHistory = history;
        this.needUpdate = true;
        this.points = null;
        this.yAxis = yAxis;
        this.yAxis.addPropertyChangeListener("VERTICAL_SCALE", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BalanceGraphic.this.revalidate();
                BalanceGraphic.this.repaint();
            }
        });
        MouseListener listener = new MouseListener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.setAutoscrolls(true);
        this.setZoomLevel(3);
    }

    private void setZoomLevel(int level) {
        this.zoomLevel = level;
        this.pixelPerDay = Math.max(1, level * this.getFont().getSize() / 12);
    }

    void setHistory(BalanceHistory history) {
        this.balanceHistory = history;
        this.needUpdate = true;
        this.repaint();
        this.revalidate();
    }

    private void restoreHistory() {
        if (this.needUpdate) {
            this.points = null;
            BalanceHistoryElement lastElement = this.balanceHistory.get(this.balanceHistory.size() - 1);
            this.endDate = lastElement.getTo();
            if (this.endDate == null) {
                if (lastElement.getFrom() != null) {
                    this.endDate = (Date)lastElement.getFrom().clone();
                }
                if (this.endDate == null) {
                    this.endDate = new Date();
                }
            }
            if (this.endDate.compareTo(new Date()) < 0) {
                this.endDate = new Date();
            }
            this.endDate.setTime(this.endDate.getTime() + 259200000L);
            this.startDate = this.balanceHistory.get(0).getFrom();
            if (this.startDate == null) {
                this.startDate = new Date();
                Date end = this.balanceHistory.get(0).getTo();
                if (end != null) {
                    this.startDate.setTime(end.getTime());
                }
            }
            this.startDate.setTime(this.startDate.getTime() - 259200000L);
            this.needUpdate = false;
        }
    }

    public Date getStartDate() {
        this.restoreHistory();
        return this.startDate;
    }

    public Date getEndDate() {
        this.restoreHistory();
        return this.endDate;
    }

    public Date getSelectedDate() {
        return this.selectedDate;
    }

    public void setSelectedDate(Date date) {
        if (!date.equals(this.selectedDate)) {
            Date oldValue = this.selectedDate;
            this.selectedDate = date;
            this.firePropertyChange(SELECTED_DATE_PROPERTY, oldValue, this.selectedDate);
            this.repaint();
        }
    }

    public boolean isGridVisible() {
        return this.gridIsVisible;
    }

    public void setGridVisible(boolean gridIsVisible) {
        if (gridIsVisible != this.gridIsVisible) {
            this.gridIsVisible = gridIsVisible;
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Point p2;
        int i;
        super.paintComponent(g);
        this.setBackground(Color.white);
        Graphics2D g2 = (Graphics2D)g;
        this.points = this.convert();
        Dimension size = this.getSize();
        g2.drawLine(0, size.height - 1, size.width, size.height - 1);
        int y0 = this.yAxis.getY(0.0);
        GradientPaint negativeGradient = new GradientPaint(0.0f, y0, Color.WHITE, 0.0f, this.yAxis.getY(this.balanceHistory.getMinBalance()), NEGATIVE);
        GradientPaint positiveGradient = new GradientPaint(0.0f, this.yAxis.getY(this.balanceHistory.getMaxBalance()), POSITIVE, 0.0f, y0, Color.WHITE);
        Point p = this.points[0];
        for (i = 0; i < this.points.length; ++i) {
            p2 = this.points[i];
            if (p2.y == p.y && Math.abs(p.y - y0) > 1) {
                GradientPaint c;
                int h;
                int y;
                if (p.y > y0) {
                    y = y0;
                    h = p.y - y0;
                    c = negativeGradient;
                } else {
                    y = p.y;
                    h = y0 - p.y;
                    c = positiveGradient;
                }
                Paint oldColor = g2.getPaint();
                g2.setPaint(c);
                g2.fillRect(p.x + 1, y, p2.x - p.x, h);
                g2.setPaint(oldColor);
            }
            p = p2;
        }
        this.paintXAxis(g2);
        this.paintYAxis(g2);
        p = this.points[0];
        for (i = 0; i < this.points.length; ++i) {
            p2 = this.points[i];
            g2.drawLine(p.x, p.y, p2.x, p2.y);
            p = p2;
        }
        int stroke = this.pixelPerDay + 1;
        int x = this.getX(this.selectedDate) + stroke / 2;
        if (x >= 0 && x <= size.width) {
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(new BasicStroke(stroke));
            Color oldColor = g2.getColor();
            g2.setColor(Color.ORANGE);
            Composite originalComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, 0.75f));
            g2.drawLine(x, 0, x, size.height);
            g2.setComposite(originalComposite);
            g2.setColor(oldColor);
            g2.setStroke(oldStroke);
        }
    }

    private void paintXAxis(Graphics2D g2) {
        int y0 = this.yAxis.getY(0.0);
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(new BasicStroke(3.0f));
        Dimension size = this.getSize();
        g2.drawLine(0, y0, size.width, y0);
        g2.setStroke(oldStroke);
        String[] months = DateFormatSymbols.getInstance(LocalizationData.getLocale()).getMonths();
        Date date = (Date)this.getStartDate().clone();
        int x = this.getX(date);
        date.setDate(1);
        FontMetrics metrics = g2.getFontMetrics();
        while (x < size.width) {
            int month = date.getMonth();
            if (x > 0) {
                boolean paintMonthName;
                if (this.isGridVisible()) {
                    Color color = g2.getColor();
                    g2.setColor(Color.LIGHT_GRAY);
                    g2.drawLine(x, 0, x, size.height);
                    g2.setColor(color);
                }
                g2.drawLine(x, y0 - 3, x, y0 + 3);
                switch (this.zoomLevel) {
                    case 1: {
                        paintMonthName = month % 3 == 0;
                        break;
                    }
                    case 2: {
                        paintMonthName = month % 2 == 0;
                        break;
                    }
                    default: {
                        paintMonthName = true;
                    }
                }
                if (paintMonthName) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(months[month]);
                    if (month == 0) {
                        buf.append(" ").append(date.getYear() + 1900);
                    }
                    String dateString = buf.toString();
                    g2.drawString(dateString, x - metrics.stringWidth(dateString) / 2, y0 + metrics.getHeight());
                }
            }
            if (++month > 12) {
                month = 1;
                date.setYear(date.getYear() + 1);
            }
            date.setMonth(month);
            x = this.getX(date);
        }
    }

    private void paintYAxis(Graphics2D g2) {
        if (this.isGridVisible()) {
            Dimension size = this.getSize();
            Color color = g2.getColor();
            g2.setColor(Color.LIGHT_GRAY);
            Iterator<Graduation> iterator = this.yAxis.getYGraduations();
            while (iterator.hasNext()) {
                Graduation graduation = iterator.next();
                g2.drawLine(0, graduation.getPosition(), size.width, graduation.getPosition());
            }
            g2.setColor(color);
        }
    }

    private void setLinePosition(double x) {
        int day = ((int)x - 0) / this.pixelPerDay;
        GregorianCalendar dummy = new GregorianCalendar();
        dummy.setTime(this.getStartDate());
        dummy.add(5, day);
        long time = dummy.getTimeInMillis();
        long max = Math.max(this.xToTime(this.getSize().width - 1), this.getEndDate().getTime());
        if (time > max) {
            time = max;
        } else if (this.getStartDate().getTime() > time) {
            time = this.getStartDate().getTime();
        }
        if (time != this.selectedDate.getTime()) {
            Date oldValue = (Date)this.selectedDate.clone();
            this.selectedDate.setTime(time);
            this.firePropertyChange(SELECTED_DATE_PROPERTY, oldValue, this.selectedDate);
            this.repaint();
        }
    }

    int getX(Date date) {
        int nbDays = (int)Math.round((double)(date.getTime() - this.getStartDate().getTime()) / 8.64E7);
        return 0 + nbDays * this.pixelPerDay;
    }

    private long xToTime(int x) {
        return (long)(x - 0) * 3600000L * 24L / (long)this.pixelPerDay + this.getStartDate().getTime();
    }

    private Point[] convert() {
        Point[] result = new Point[this.balanceHistory.size() * 2];
        for (int i = 0; i < this.balanceHistory.size(); ++i) {
            long rightWindowTime;
            BalanceHistoryElement element = this.balanceHistory.get(i);
            Date from = element.getFrom();
            if (from == null) {
                from = this.getStartDate();
            }
            int y = this.yAxis.getY(element.getBalance());
            long x = this.getX(from);
            result[i * 2] = new Point((int)x, y);
            Date to = element.getTo();
            if (to == null && (rightWindowTime = this.xToTime(this.getSize().width - 1)) > (to = new Date(from.getTime() + 259200000L)).getTime()) {
                to.setTime(rightWindowTime);
            }
            x = this.getX(to);
            result[i * 2 + 1] = new Point((int)x, y);
        }
        return result;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension parentSize = this.getParent().getSize();
        Date end = NullUtils.compareTo(this.getPreferredEndDate(), this.getEndDate(), false) < 0 ? this.getPreferredEndDate() : this.getEndDate();
        long days = 1L + (end.getTime() - this.getStartDate().getTime()) / 24L / 3600000L;
        int pixels = (int)(days * (long)this.pixelPerDay);
        int width = Math.max(pixels, parentSize.width);
        return new Dimension(width, parentSize.height * this.yAxis.getVerticalScale());
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getParent().getSize().width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.pixelPerDay;
    }

    public void setPreferredEndDate(Date endDate) {
        this.preferredEndDate = endDate;
        this.revalidate();
    }

    public Date getPreferredEndDate() {
        return this.preferredEndDate;
    }

    public void setHorizontalScale(int value) {
        this.setZoomLevel(value);
        this.repaint();
        this.revalidate();
    }

    public int getHorizontalScale() {
        return this.zoomLevel;
    }

    private static class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            Rectangle r = new Rectangle(x, e.getY(), 1, 1);
            ((JPanel)e.getSource()).scrollRectToVisible(r);
            this.computeEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.computeEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.computeEvent(e);
        }

        private void computeEvent(MouseEvent e) {
            BalanceGraphic bgp = (BalanceGraphic)e.getSource();
            bgp.setLinePosition(e.getX());
        }
    }
}

