/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.graphics.balancehistory;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.widget.RotatingLabel;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.yapbam.data.Alert;
import net.yapbam.data.BalanceHistory;
import net.yapbam.data.FilteredData;
import net.yapbam.data.GlobalData;
import net.yapbam.data.event.AccountAddedEvent;
import net.yapbam.data.event.AccountPropertyChangedEvent;
import net.yapbam.data.event.AccountRemovedEvent;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.data.event.EverythingChangedEvent;
import net.yapbam.data.event.TransactionsAddedEvent;
import net.yapbam.data.event.TransactionsRemovedEvent;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.YapbamState;
import net.yapbam.gui.graphics.balancehistory.AlertsPane;
import net.yapbam.gui.graphics.balancehistory.BalanceGraphic;
import net.yapbam.gui.graphics.balancehistory.BalanceHistoryControlPane;
import net.yapbam.gui.graphics.balancehistory.BalanceRule;
import net.yapbam.util.DateUtils;

public class BalanceHistoryGraphPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JScrollPane scrollPane;
    private BalanceGraphic graph;
    private BalanceHistoryControlPane control;
    private AlertsPane alerts;
    private BalanceRule rule;
    private FilteredData data;
    private JSlider slider;
    private boolean ignoreEnd;

    private BalanceHistoryGraphPane() {
        this(new FilteredData(new GlobalData()));
    }

    public BalanceHistoryGraphPane(FilteredData data) {
        super(new BorderLayout());
        this.data = data;
        this.graph = new BalanceGraphic(this.getBalanceHistory(), this.getBalanceRule().getYAxis());
        this.graph.setToolTipText(LocalizationData.get("BalanceHistory.chart.toolTip"));
        this.graph.addPropertyChangeListener("selectedDate", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BalanceHistoryGraphPane.this.control.setReportText(BalanceHistoryGraphPane.this.getBalanceReportText());
            }
        });
        this.scrollPane = new JScrollPane(this.graph, 20, 30);
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.setRowHeaderView(this.getBalanceRule());
        this.control = new BalanceHistoryControlPane();
        this.alerts = new AlertsPane();
        this.control.getIsGridVisible().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BalanceHistoryGraphPane.this.graph.setGridVisible(e.getStateChange() == 1);
            }
        });
        this.control.getToday().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date today = DateUtils.getMidnight(new Date());
                BalanceHistoryGraphPane.this.setSelectedDate(today);
            }
        });
        this.control.getSlider().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JViewport vp = BalanceHistoryGraphPane.this.scrollPane.getViewport();
                int startX = vp.getViewPosition().x;
                int y = vp.getViewPosition().y;
                int startPrefWidth = ((BalanceHistoryGraphPane)BalanceHistoryGraphPane.this).graph.getPreferredSize().width;
                int width = vp.getWidth();
                BalanceHistoryGraphPane.this.graph.setHorizontalScale(BalanceHistoryGraphPane.this.control.getSlider().getValue());
                int endPrefWidth = ((BalanceHistoryGraphPane)BalanceHistoryGraphPane.this).graph.getPreferredSize().width;
                if (startX == startPrefWidth - width) {
                    vp.setViewPosition(new Point(endPrefWidth - width, y));
                } else if (startX != 0) {
                    // empty if block
                }
            }
        });
        this.control.setReportText(this.getBalanceReportText());
        this.alerts.getAlerts().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Alert alert = BalanceHistoryGraphPane.this.alerts.getSelectedAlert();
                BalanceHistoryGraphPane.this.data.getFilter().setValidAccounts(Collections.singletonList(alert.getAccount()));
                BalanceHistoryGraphPane.this.setSelectedDate(alert.getDate());
            }
        });
        this.add((Component)this.alerts, "North");
        this.add((Component)this.control, "South");
        JPanel leftPanel = new JPanel();
        leftPanel.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.add((Component)leftPanel, "West");
        leftPanel.setLayout(new BorderLayout(0, 0));
        RotatingLabel lblZoom = new RotatingLabel();
        lblZoom.setHorizontalAlignment(0);
        lblZoom.setText(LocalizationData.get("BalanceHistory.zoom"));
        lblZoom.setRotation(-90);
        leftPanel.add((Component)lblZoom, "South");
        this.slider = new JSlider(1, 1, 20, 1);
        this.slider.setPaintTicks(true);
        this.slider.setSnapToTicks(true);
        this.slider.setMinorTickSpacing(1);
        leftPanel.add((Component)this.slider, "East");
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JViewport vp = BalanceHistoryGraphPane.this.scrollPane.getViewport();
                int startY = vp.getViewPosition().y;
                int x = vp.getViewPosition().x;
                int startPrefHeight = ((BalanceHistoryGraphPane)BalanceHistoryGraphPane.this).graph.getPreferredSize().height;
                int height = vp.getHeight();
                BalanceHistoryGraphPane.this.rule.getYAxis().setVerticalScale(BalanceHistoryGraphPane.this.slider.getValue());
                int endPrefHeight = ((BalanceHistoryGraphPane)BalanceHistoryGraphPane.this).graph.getPreferredSize().height;
                if (startY == startPrefHeight - height || startPrefHeight == height) {
                    vp.setViewPosition(new Point(x, endPrefHeight - height));
                } else if (startY != 0) {
                    // empty if block
                }
            }
        });
        data.addListener(new DataListener(){

            @Override
            public void processEvent(DataEvent event) {
                if (event instanceof EverythingChangedEvent || event instanceof AccountAddedEvent || event instanceof AccountRemovedEvent || event instanceof AccountPropertyChangedEvent || event instanceof TransactionsAddedEvent || event instanceof TransactionsRemovedEvent) {
                    BalanceHistoryGraphPane.this.onDataChanged();
                }
            }
        });
        this.onDataChanged();
    }

    private BalanceHistory getBalanceHistory() {
        return this.data.getBalanceData().getBalanceHistory();
    }

    private BalanceRule getBalanceRule() {
        if (this.rule == null) {
            this.rule = new BalanceRule();
        }
        return this.rule;
    }

    private String getBalanceReportText() {
        Date date = this.graph.getSelectedDate();
        String dateStr = DateFormat.getDateInstance(3, LocalizationData.getLocale()).format(date);
        String balance = LocalizationData.getCurrencyInstance().format(this.getBalanceHistory().getBalance(date));
        return Formatter.format(LocalizationData.get("BalanceHistory.balance"), dateStr, balance);
    }

    private void onDataChanged() {
        Date endDate = this.ignoreEnd ? null : this.data.getFilter().getValueDateTo();
        double min = Math.min(0.0, this.getBalanceHistory().getMinBalance(endDate));
        double max = Math.max(0.0, this.getBalanceHistory().getMaxBalance(endDate));
        this.getBalanceRule().getYAxis().setBounds(min, max);
        this.getBalanceRule().revalidate();
        this.graph.setPreferredEndDate(endDate);
        this.graph.setHistory(this.getBalanceHistory());
        if (this.graph.getSelectedDate().compareTo(this.graph.getStartDate()) < 0 || this.graph.getSelectedDate().compareTo(this.graph.getEndDate()) > 0) {
            this.graph.setSelectedDate(new Date());
        } else {
            this.control.setReportText(this.getBalanceReportText());
        }
        this.scrollToSelectedDate();
    }

    private void setSelectedDate(Date date) {
        if (NullUtils.compareTo(date, this.data.getFilter().getValueDateFrom(), true) < 0) {
            this.data.getFilter().setValueDateFilter(date, this.data.getFilter().getValueDateTo());
        } else if (NullUtils.compareTo(date, this.data.getFilter().getValueDateTo(), false) > 0) {
            this.data.getFilter().setValueDateFilter(this.data.getFilter().getValueDateFrom(), date);
        }
        this.graph.setSelectedDate(date);
        this.scrollToSelectedDate();
    }

    void scrollToSelectedDate() {
        JViewport viewport = this.scrollPane.getViewport();
        int viewWidth = viewport.getWidth();
        int selected = this.graph.getX(this.graph.getSelectedDate());
        int graphWidth = this.graph.getPreferredSize().width;
        if (viewport.getViewPosition().x > selected || viewport.getViewPosition().x + viewWidth < selected) {
            int position = selected - viewWidth / 2;
            if (position < 0) {
                position = 0;
            } else if (position + viewWidth > graphWidth) {
                position = graphWidth - viewWidth;
            }
            viewport.setViewPosition(new Point(position, 0));
        }
    }

    public void setAlerts(Alert[] alerts) {
        this.alerts.setAlerts(alerts);
    }

    public void setIgnoreEnd(boolean ignoreEnd) {
        if (this.ignoreEnd != ignoreEnd) {
            this.ignoreEnd = ignoreEnd;
            Date endDate = ignoreEnd ? null : this.data.getFilter().getValueDateTo();
            double min = Math.min(0.0, this.getBalanceHistory().getMinBalance(endDate));
            double max = Math.max(0.0, this.getBalanceHistory().getMaxBalance(endDate));
            this.getBalanceRule().getYAxis().setBounds(min, max);
            this.graph.setPreferredEndDate(endDate);
            this.scrollToSelectedDate();
        }
    }

    public void saveState() {
        YapbamState.INSTANCE.put(this.getVerticalZoomStateKey(), Integer.toString(this.slider.getValue()));
        this.control.saveState();
    }

    private String getVerticalZoomStateKey() {
        return this.getClass().getCanonicalName() + ".verticalZoom";
    }

    public void restoreState() {
        this.control.restoreState();
        Integer value = YapbamState.INSTANCE.getInteger(this.getVerticalZoomStateKey());
        if (value != null) {
            this.slider.setValue(value);
        }
    }
}

