/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.graphics.balancehistory;

import net.yapbam.gui.graphics.balancehistory.TablePreferencePanel;
import net.yapbam.gui.transactiontable.TransactionTableSettings;

class TableSettings
extends TransactionTableSettings {
    private static final long serialVersionUID = 1L;

    TableSettings() {
        this.isReceiptsSeparatedFromExpenses = TablePreferencePanel.isReceiptSeparatedFromExpense();
    }

    int getColumnCount() {
        return this.getRemainingColumn() + 1;
    }

    int getAccountColumn() {
        return 0;
    }

    int getDateColumn() {
        return 1;
    }

    int getDescriptionColumn() {
        return 2;
    }

    int getCommentColumn() {
        return this.isCommentSeparatedFromDescription() ? 3 : -1;
    }

    int getAmountColumn() {
        if (this.isReceiptsSeparatedFromExpenses()) {
            return -1;
        }
        return this.isCommentSeparatedFromDescription() ? 4 : 3;
    }

    int getReceiptColumn() {
        if (this.isReceiptsSeparatedFromExpenses()) {
            return this.isCommentSeparatedFromDescription() ? 4 : 3;
        }
        return -1;
    }

    int getExpenseColumn() {
        if (this.isReceiptsSeparatedFromExpenses()) {
            return this.getReceiptColumn() + 1;
        }
        return -1;
    }

    int getCategoryColumn() {
        int result = 4;
        if (this.isCommentSeparatedFromDescription()) {
            ++result;
        }
        if (this.isReceiptsSeparatedFromExpenses()) {
            ++result;
        }
        return result;
    }

    int getModeColumn() {
        return this.getCategoryColumn() + 1;
    }

    int getNumberColumn() {
        return this.getCategoryColumn() + 2;
    }

    int getValueDateColumn() {
        return this.getCategoryColumn() + 3;
    }

    int getStatementColumn() {
        return this.getCategoryColumn() + 4;
    }

    int getRemainingColumn() {
        return this.getCategoryColumn() + 5;
    }
}

