/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.info;

import java.util.Iterator;
import java.util.List;

public abstract class FilteredList<T>
implements Iterable<T> {
    protected List<T> physical;

    public FilteredList(List<T> news) {
        this.physical = news;
    }

    public int getPhysicalSize() {
        return this.physical.size();
    }

    public int size() {
        int result = 0;
        for (T element : this.physical) {
            if (!this.isOk(element)) continue;
            ++result;
        }
        return result;
    }

    protected abstract boolean isOk(T var1);

    public T get(int index) {
        int count = -1;
        for (T element : this.physical) {
            if (!this.isOk(element) || ++count != index) continue;
            return element;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public boolean isEmpty() {
        for (T info : this.physical) {
            if (!this.isOk(info)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                for (int i = this.index; i < FilteredList.this.physical.size(); ++i) {
                    if (!FilteredList.this.isOk(FilteredList.this.physical.get(i))) continue;
                    return true;
                }
                return false;
            }

            @Override
            public T next() {
                Object result = FilteredList.this.get(this.index);
                ++this.index;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

