/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.info;

import java.util.List;
import net.yapbam.gui.info.FilteredList;
import net.yapbam.gui.info.Message;

public class Messages
extends FilteredList<Message> {
    private boolean onlyUnread = true;

    public Messages(List<Message> news) {
        super(news);
    }

    @Override
    public int size() {
        if (this.onlyUnread) {
            return super.size();
        }
        return this.getPhysicalSize();
    }

    @Override
    public Message get(int index) {
        if (this.onlyUnread) {
            return (Message)super.get(index);
        }
        return (Message)this.physical.get(index);
    }

    @Override
    protected boolean isOk(Message element) {
        return !this.onlyUnread || !element.isRead();
    }

    public boolean isOnlyUnread() {
        return this.onlyUnread;
    }

    public void setOnlyUnread(boolean onlyUnread) {
        this.onlyUnread = onlyUnread;
    }

    public int getNbRead() {
        int read = 0;
        for (Message message : this.physical) {
            if (!message.isRead()) continue;
            ++read;
        }
        return read;
    }

    public boolean isAllRead() {
        for (Message message : this.physical) {
            if (message.isRead()) continue;
            return false;
        }
        return true;
    }

    public int getNearest(Message message) {
        int size;
        int index = -1;
        for (Message m : this.physical) {
            boolean ok = this.isOk(m);
            if (ok) {
                ++index;
            }
            if (!m.getId().equals(message.getId())) continue;
            if (ok) break;
            ++index;
            break;
        }
        if (index >= (size = this.size())) {
            index = size == 0 ? -1 : 0;
        }
        return index;
    }
}

