/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.info;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.widget.HTMLPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.info.Message;
import net.yapbam.gui.info.Messages;
import net.yapbam.gui.info.MessagesCommandPanel;

public class MessagesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton closeBtn;
    private HTMLPane textPane;
    private Messages messages;
    private JButton displayButton;
    private MessagesCommandPanel panel;
    private JLabel titleLabel;
    private JPanel panel_1;
    private JLabel icon;

    public MessagesPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbcTitleLabel = new GridBagConstraints();
        gbcTitleLabel.insets = new Insets(2, 5, 5, 5);
        gbcTitleLabel.gridx = 0;
        gbcTitleLabel.gridy = 0;
        this.add((Component)this.getTitleLabel(), gbcTitleLabel);
        GridBagConstraints gbcCloseBtn = new GridBagConstraints();
        gbcCloseBtn.insets = new Insets(2, 0, 5, 2);
        gbcCloseBtn.weightx = 1.0;
        gbcCloseBtn.anchor = 12;
        gbcCloseBtn.gridx = 1;
        gbcCloseBtn.gridy = 0;
        this.add((Component)this.getCloseBtn(), gbcCloseBtn);
        GridBagConstraints gbcPanel_1 = new GridBagConstraints();
        gbcPanel_1.weighty = 1.0;
        gbcPanel_1.weightx = 1.0;
        gbcPanel_1.fill = 1;
        gbcPanel_1.gridwidth = 0;
        gbcPanel_1.insets = new Insets(0, 5, 0, 0);
        gbcPanel_1.gridx = 0;
        gbcPanel_1.gridy = 1;
        this.add((Component)this.getPanel_1(), gbcPanel_1);
        this.setVisible(false);
        GridBagConstraints gbcPanel = new GridBagConstraints();
        gbcPanel.gridwidth = 0;
        gbcPanel.weightx = 1.0;
        gbcPanel.insets = new Insets(0, 5, 0, 0);
        gbcPanel.fill = 1;
        gbcPanel.gridx = 0;
        gbcPanel.gridy = 2;
        this.add((Component)this.getPanel(), gbcPanel);
    }

    private JButton getCloseBtn() {
        if (this.closeBtn == null) {
            this.closeBtn = new JButton(IconManager.get(IconManager.Name.CLOSE));
            this.closeBtn.setBorder(BorderFactory.createEmptyBorder());
            this.closeBtn.setBorderPainted(false);
            this.closeBtn.setFocusPainted(false);
            this.closeBtn.setContentAreaFilled(false);
            this.closeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MessagesPanel.this.setVisible(false);
                }
            });
            this.closeBtn.setToolTipText(LocalizationData.get("messages.close.tooltip"));
        }
        return this.closeBtn;
    }

    private HTMLPane getTextPane() {
        if (this.textPane == null) {
            this.textPane = new HTMLPane();
            this.textPane.setContent(this.getNoMessageWording());
            this.textPane.addPropertyChangeListener("CHANGED", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    MessagesPanel.this.revalidate();
                }
            });
        }
        return this.textPane;
    }

    public void setMessages(List<Message> newsList) {
        this.messages = new Messages(newsList);
        boolean isEmpty = this.messages.isEmpty();
        this.setVisible(!isEmpty);
        this.setMessage(isEmpty ? -1 : 0);
    }

    private void setMessage(int index) {
        int size = this.messages.size();
        this.getPanel().getPageSelector().setVisible(size != 0);
        this.getPanel().getPageSelector().setPage(-1);
        this.getPanel().getPageSelector().setPageCount(size);
        if (index >= 0) {
            this.getPanel().getPageSelector().setPage(index);
        }
        this.refreshButtons(index);
    }

    private void refreshButtons(int index) {
        Message message = index < 0 ? null : this.messages.get(index);
        this.getPanel().getMarkAsReadButton().setEnabled(message != null && !message.isRead());
        int read = this.messages.getNbRead();
        this.getPanel().getShowReadCheckBox().setEnabled(read != 0);
        this.getPanel().getShowReadCheckBox().setText(Formatter.format(LocalizationData.get("messages.showReadMessages"), read, this.messages.getPhysicalSize()));
        this.getTitleLabel().setIcon(IconManager.get(read == this.messages.getPhysicalSize() ? IconManager.Name.MESSAGE : IconManager.Name.NEW_MESSAGE));
        this.getIcon().setIcon(this.getIcon(message));
    }

    private Icon getIcon(Message message) {
        if (message == null) {
            return null;
        }
        if (Message.Kind.WARNING.equals((Object)message.getKind())) {
            return UIManager.getIcon("OptionPane.warningIcon");
        }
        return UIManager.getIcon("OptionPane.informationIcon");
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.displayButton != null) {
            this.displayButton.setVisible(!visible && this.messages.getPhysicalSize() != 0);
            this.displayButton.setIcon(IconManager.get(this.messages.isAllRead() ? IconManager.Name.MESSAGE : IconManager.Name.NEW_MESSAGE));
        }
        if (visible && !this.getPanel().getShowReadCheckBox().isSelected() && this.messages.isEmpty()) {
            this.getPanel().getShowReadCheckBox().setSelected(true);
        }
    }

    public void setDisplayButton(JButton displayButton) {
        this.displayButton = displayButton;
        if (displayButton != null) {
            this.displayButton.setToolTipText(LocalizationData.get("messages.open.tooltip"));
            this.displayButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MessagesPanel.this.setVisible(true);
                }
            });
        }
    }

    private MessagesCommandPanel getPanel() {
        if (this.panel == null) {
            this.panel = new MessagesCommandPanel();
            this.panel.getMarkAsReadButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = MessagesPanel.this.panel.getPageSelector().getPageNumber().getValue().intValue() - 1;
                    Message message = MessagesPanel.this.messages.get(index);
                    message.markRead();
                    if (MessagesPanel.this.messages.isOnlyUnread()) {
                        if (MessagesPanel.this.messages.isEmpty()) {
                            MessagesPanel.this.setVisible(false);
                            MessagesPanel.this.setMessage(-1);
                        } else if (index <= MessagesPanel.this.messages.size() - 1) {
                            MessagesPanel.this.setMessage(index);
                        } else {
                            MessagesPanel.this.setMessage(0);
                        }
                    } else if (index < MessagesPanel.this.messages.size() - 1) {
                        MessagesPanel.this.setMessage(index + 1);
                    } else {
                        MessagesPanel.this.setMessage(0);
                    }
                }
            });
            this.panel.getShowReadCheckBox().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean onlyUnread = e.getStateChange() == 2;
                    Message message = MessagesPanel.this.getMessage();
                    MessagesPanel.this.messages.setOnlyUnread(onlyUnread);
                    if (MessagesPanel.this.messages.isEmpty()) {
                        MessagesPanel.this.setMessage(-1);
                    } else if (message == null) {
                        MessagesPanel.this.setMessage(0);
                    } else {
                        MessagesPanel.this.setMessage(MessagesPanel.this.messages.getNearest(message));
                    }
                }
            });
            this.panel.getPageSelector().addPropertyChangeListener("PageSelected", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int index = (Integer)evt.getNewValue();
                    MessagesPanel.this.getTextPane().setContent(index < 0 ? MessagesPanel.this.getNoMessageWording() : MessagesPanel.this.messages.get(index).getContent());
                    MessagesPanel.this.refreshButtons(index);
                }
            });
        }
        return this.panel;
    }

    private JLabel getTitleLabel() {
        if (this.titleLabel == null) {
            this.titleLabel = new JLabel(Formatter.format("<HTML><U><B>{0}</B></U></HTML>", LocalizationData.get("messages.title")));
            this.titleLabel.setFont(this.titleLabel.getFont().deriveFont((float)this.titleLabel.getFont().getSize() * 1.2f));
        }
        return this.titleLabel;
    }

    private Message getMessage() {
        int index = this.getPanel().getPageSelector().getCurrentPage();
        return index < 0 ? null : this.messages.get(index);
    }

    private String getNoMessageWording() {
        return Formatter.format("<html>{0}</html>", LocalizationData.get("messagesnoMessageAvailable"));
    }

    private JPanel getPanel_1() {
        if (this.panel_1 == null) {
            this.panel_1 = new JPanel();
            this.panel_1.setLayout(new BorderLayout(0, 0));
            this.panel_1.add(this.getTextPane());
            this.panel_1.add((Component)this.getIcon(), "West");
        }
        return this.panel_1;
    }

    private JLabel getIcon() {
        if (this.icon == null) {
            this.icon = new JLabel();
        }
        return this.icon;
    }
}

