/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.persistence;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.worker.WorkInProgressFrame;
import com.fathzer.soft.ajlib.swing.worker.WorkInProgressPanel;
import com.fathzer.soft.ajlib.swing.worker.Worker;
import com.fathzer.soft.jclop.Service;
import com.fathzer.soft.jclop.swing.URIChooser;
import com.fathzer.soft.jclop.swing.URIChooserDialog;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import net.yapbam.data.xml.UnsupportedFileVersionException;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.BasicHTMLDialog;
import net.yapbam.gui.persistence.DataWrapper;
import net.yapbam.gui.persistence.PersistenceAdapter;
import net.yapbam.gui.persistence.UnsupportedSchemeException;
import net.yapbam.gui.persistence.reading.DataReader;
import net.yapbam.gui.persistence.writing.DataWriter;

public abstract class PersistenceManager {
    private Map<String, PersistenceAdapter> adaptersMap = new HashMap<String, PersistenceAdapter>();
    private List<String> schemes = new ArrayList<String>();

    public void add(PersistenceAdapter adapter) {
        String scheme = adapter.getService().getScheme();
        if (this.adaptersMap.containsKey(scheme)) {
            throw new IllegalArgumentException(Formatter.format("Can't have two adapters for {0} scheme", scheme));
        }
        this.adaptersMap.put(scheme, adapter);
        this.schemes.add(scheme);
    }

    public WorkInProgressFrame buildWaitDialog(Window owner, Worker<?, ?> worker) {
        WorkInProgressFrame waitFrame = new WorkInProgressFrame(owner, LocalizationData.get("Generic.wait.title"), Dialog.ModalityType.APPLICATION_MODAL, worker);
        WorkInProgressPanel panel = waitFrame.getWorkInProgressPanel();
        Dimension oldPref = panel.getPreferredSize();
        panel.setPreferredSize(new Dimension(Math.max(400, oldPref.width), oldPref.height));
        waitFrame.pack();
        waitFrame.setLocationRelativeTo(owner);
        return waitFrame;
    }

    public boolean verify(Window owner, DataWrapper<?> data) {
        if (data.isChanged() && !data.isEmpty()) {
            Object[] options = new String[]{LocalizationData.get("NotSavedDialog.save"), LocalizationData.get("NotSavedDialog.ignore"), LocalizationData.get("GenericButton.cancel")};
            int n = JOptionPane.showOptionDialog(owner, LocalizationData.get("NotSavedDialog.message"), LocalizationData.get("NotSavedDialog.title"), 1, 2, null, options, options[2]);
            if (n == 2) {
                return false;
            }
            if (n == 0) {
                return this.save(owner, data);
            }
        }
        return true;
    }

    public boolean save(Window owner, DataWrapper<?> data) {
        URI uri = data.getURI();
        if (uri == null) {
            uri = this.getURI(owner, uri, true);
        }
        if (uri == null) {
            return false;
        }
        return this.saveTo(owner, data, uri);
    }

    public boolean saveAs(Window owner, DataWrapper<?> data) {
        URI uri = this.getURI(owner, data.getURI(), true);
        if (uri == null) {
            return false;
        }
        return this.saveTo(owner, data, uri);
    }

    private URI getURI(Window owner, URI uri, boolean save) {
        URIChooserDialog dialog = this.getChooserDialog(owner);
        dialog.setSaveDialog(save);
        if (uri != null && dialog.hasScheme(uri.getScheme())) {
            dialog.setSelectedURI(uri);
        }
        String title = save ? LocalizationData.get("MainMenu.Save") : LocalizationData.get("MainMenu.Open");
        dialog.setTitle(title);
        dialog.pack();
        return dialog.showDialog();
    }

    public URIChooserDialog getChooserDialog(Window owner) {
        ArrayList<URIChooser> panels = new ArrayList<URIChooser>(this.getAdaptersNumber());
        for (int i = 0; i < this.getAdaptersNumber(); ++i) {
            URIChooser chooser = this.getAdapter(i).buildChooser();
            if (chooser == null) continue;
            panels.add(chooser);
        }
        URIChooserDialog dialog = new URIChooserDialog(owner, "", panels.toArray(new URIChooser[panels.size()]));
        dialog.setLocale(LocalizationData.getLocale());
        return dialog;
    }

    private boolean saveTo(Window owner, DataWrapper<?> data, URI uri) {
        return new DataWriter(this, owner, data, uri).save();
    }

    public boolean read(Window frame, DataWrapper<?> data, URI path, ErrorProcessor errProcessor) {
        block10: {
            if (this.verify(frame, data)) {
                if (path == null) {
                    path = this.getURI(frame, data.getURI(), false);
                }
                if (path != null) {
                    try {
                        return new DataReader(this, frame, data, path).read();
                    }
                    catch (ExecutionException e) {
                        String displayedURI;
                        Throwable exception = e.getCause();
                        boolean notProcessed = true;
                        if (errProcessor != null) {
                            boolean bl = notProcessed = !errProcessor.processError(exception);
                        }
                        if (!notProcessed) break block10;
                        PersistenceAdapter adapter = this.getAdapter(path);
                        Service service = adapter == null ? null : adapter.getService();
                        String string = displayedURI = service == null ? path.toString() : service.getDisplayable(path);
                        if (exception instanceof FileNotFoundException) {
                            File file = service.getLocalFile(path);
                            if (file.exists()) {
                                String message = "file".equals(path.getScheme()) ? Formatter.format(LocalizationData.get("openDialog.fileNotReadable"), displayedURI) : Formatter.format(LocalizationData.get("openDialog.cacheNotReadable"), file);
                                JOptionPane.showMessageDialog(frame, message, LocalizationData.get("ErrorManager.title"), 2);
                            }
                            throw new RuntimeException(exception);
                        }
                        if (exception instanceof UnsupportedFileVersionException) {
                            String message = Formatter.format(LocalizationData.get("MainMenu.Open.Error.DialogContent.needUpdate"), adapter.getService().getDisplayable(path));
                            JOptionPane.showMessageDialog(frame, message, LocalizationData.get("ErrorManager.title"), 2);
                        }
                        if (exception instanceof IOException) {
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            exception.printStackTrace(new PrintStream(out));
                            String trace = out.toString();
                            trace = trace.replace("\t", "  ");
                            BasicHTMLDialog dialog = new BasicHTMLDialog(frame, LocalizationData.get("ErrorManager.title"), Formatter.format(LocalizationData.get("MainMenu.Open.Error.DialogContent"), displayedURI), BasicHTMLDialog.Type.ERROR);
                            dialog.setContent(trace);
                            dialog.setVisible(true);
                        }
                        if (exception instanceof UnsupportedSchemeException) break block10;
                        throw new RuntimeException(exception);
                    }
                }
            }
        }
        return false;
    }

    public int getAdaptersNumber() {
        return this.schemes.size();
    }

    public PersistenceAdapter getAdapter(int index) {
        return this.adaptersMap.get(this.schemes.get(index));
    }

    public PersistenceAdapter getAdapter(URI uri) {
        return this.adaptersMap.get(uri.getScheme());
    }

    public static interface ErrorProcessor {
        public boolean processError(Throwable var1);
    }
}

