/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.persistence;

import com.fathzer.soft.jclop.Cancellable;
import com.fathzer.soft.jclop.Service;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import net.yapbam.data.GlobalData;
import net.yapbam.data.xml.YapbamSerializer;
import net.yapbam.gui.persistence.DataWrapper;
import net.yapbam.gui.persistence.ProgressReportAdapter;

public class YapbamDataWrapper
extends DataWrapper<GlobalData> {
    public YapbamDataWrapper(GlobalData data) {
        super(data);
    }

    @Override
    public boolean isChanged() {
        return ((GlobalData)this.data).somethingHasChanged();
    }

    @Override
    public void setUnchanged() {
        ((GlobalData)this.data).setChanged(false);
    }

    @Override
    public URI getURI() {
        return ((GlobalData)this.data).getURI();
    }

    @Override
    public void setURI(URI uri) {
        ((GlobalData)this.data).setURI(uri);
    }

    @Override
    public void serialize(File file, Service service, Cancellable cancellable) throws IOException {
        YapbamSerializer.write((GlobalData)this.data, file, !service.isLocal(), new ProgressReportAdapter(cancellable));
    }

    @Override
    public GlobalData deserialize(File file, String password, Service service, Cancellable cancellable) throws IOException {
        return YapbamSerializer.read(file.toURI(), password, new ProgressReportAdapter(cancellable));
    }

    @Override
    public void clear() {
        ((GlobalData)this.data).clear();
    }

    @Override
    public boolean needPassword(File file) throws IOException {
        return !YapbamSerializer.isPasswordOk(file.toURI(), null);
    }

    @Override
    public void commit(URI uri, Object newData) {
        boolean enabled = ((GlobalData)this.data).isEventsEnabled();
        ((GlobalData)this.data).setEventsEnabled(false);
        ((GlobalData)this.data).copy((GlobalData)newData);
        ((GlobalData)this.data).setChanged(false);
        ((GlobalData)this.data).setURI(uri);
        ((GlobalData)this.data).setEventsEnabled(enabled);
    }

    @Override
    public boolean isEmpty() {
        return ((GlobalData)this.data).isEmpty();
    }
}

