/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.recent;

import com.fathzer.soft.ajlib.swing.Utils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.net.URI;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import net.yapbam.data.GlobalData;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.persistence.PersistenceManager;
import net.yapbam.gui.persistence.YapbamDataWrapper;
import net.yapbam.gui.persistence.YapbamPersistenceManager;
import net.yapbam.gui.recent.RecentFilesPlugin;

public class RecentFileAction
extends AbstractAction {
    private URI uri;
    private GlobalData data;
    private RecentFilesPlugin plugin;

    public RecentFileAction(RecentFilesPlugin plugin, URI uri, GlobalData data) {
        super(YapbamPersistenceManager.MANAGER.getAdapter(uri).getService().getDisplayable(uri));
        this.plugin = plugin;
        this.uri = uri;
        this.data = data;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final Window ownerWindow = Utils.getOwnerWindow((Component)e.getSource());
        YapbamPersistenceManager.MANAGER.read(ownerWindow, new YapbamDataWrapper(this.data), this.uri, new PersistenceManager.ErrorProcessor(){

            @Override
            public boolean processError(Throwable e) {
                if (e instanceof FileNotFoundException) {
                    String cancel = LocalizationData.get("GenericButton.cancel");
                    int result = JOptionPane.showOptionDialog(ownerWindow, LocalizationData.get("RecentFiles.unreachable.message"), LocalizationData.get("RecentFiles.unreachable.title"), 0, 2, null, new String[]{LocalizationData.get("GenericButton.yes"), cancel}, cancel);
                    if (result == 0) {
                        RecentFileAction.this.plugin.remove(RecentFileAction.this.uri);
                    }
                    return true;
                }
                return false;
            }
        });
    }
}

