/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.statementview;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.widget.TextWidget;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Statement;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.widget.CurrencyWidget;

public class BalancePanel
extends JPanel {
    public static final String EDITED_STATEMENT_PROPERTY = "editedStatement";
    private static final long serialVersionUID = 1L;
    private JLabel startBalance;
    private JLabel endBalance;
    private JLabel labelStatement;
    private JPanel panel;
    private JTextField statementField;
    private JLabel warningLabel;
    private String editedStatement;
    private Font bigFont;
    private CurrencyWidget targetAmount;
    private JLabel gapLabel;
    private Statement statement = null;

    public BalancePanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 3, 0, Color.gray));
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.anchor = 13;
        gridBagConstraints6.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.gridy = 1;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridy = 1;
        this.startBalance = new JLabel();
        this.startBalance.setHorizontalTextPosition(10);
        this.bigFont = this.startBalance.getFont().deriveFont(14.0f * (float)this.startBalance.getFont().getSize() / 12.0f);
        this.startBalance.setFont(this.bigFont);
        this.endBalance = new JLabel();
        this.endBalance.setHorizontalAlignment(4);
        this.endBalance.setFont(this.bigFont);
        this.panel = new JPanel();
        this.panel.setOpaque(false);
        GridBagConstraints gbcPanel = new GridBagConstraints();
        gbcPanel.anchor = 13;
        gbcPanel.fill = 2;
        gbcPanel.gridwidth = 0;
        gbcPanel.gridx = 0;
        gbcPanel.gridy = 0;
        this.add((Component)this.panel, gbcPanel);
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcLabelStatement = new GridBagConstraints();
        gbcLabelStatement.insets = new Insets(0, 5, 0, 0);
        gbcLabelStatement.anchor = 17;
        gbcLabelStatement.gridx = 0;
        gbcLabelStatement.gridy = 0;
        this.panel.add((Component)this.getLabelStatement(), gbcLabelStatement);
        this.statementField = new TextWidget(8);
        this.statementField.setFont(this.bigFont);
        this.statementField.setMinimumSize(this.statementField.getPreferredSize());
        this.statementField.setToolTipText(LocalizationData.get("CheckModePanel.statement.tooltip"));
        GridBagConstraints gbcStatementField = new GridBagConstraints();
        gbcStatementField.insets = new Insets(0, 5, 0, 0);
        gbcStatementField.fill = 2;
        gbcStatementField.gridx = 1;
        gbcStatementField.gridy = 0;
        this.panel.add((Component)this.statementField, gbcStatementField);
        this.statementField.setColumns(10);
        this.statementField.addPropertyChangeListener("text", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String old = BalancePanel.this.editedStatement;
                BalancePanel.this.editedStatement = BalancePanel.this.statementField.getText().trim();
                if (BalancePanel.this.editedStatement.isEmpty()) {
                    BalancePanel.this.editedStatement = null;
                }
                BalancePanel.this.getLabelStatement().setForeground(BalancePanel.this.editedStatement != null ? Color.black : Color.red);
                BalancePanel.this.firePropertyChange(BalancePanel.EDITED_STATEMENT_PROPERTY, old, BalancePanel.this.editedStatement);
            }
        });
        this.warningLabel = new JLabel(IconManager.get(IconManager.Name.ALERT));
        this.warningLabel.setText(LocalizationData.get("CheckModePanel.notLast.message"));
        this.warningLabel.setForeground(Color.RED);
        GridBagConstraints gbcWarningLabel = new GridBagConstraints();
        gbcWarningLabel.anchor = 13;
        gbcWarningLabel.insets = new Insets(0, 10, 0, 5);
        gbcWarningLabel.gridx = 2;
        gbcWarningLabel.gridy = 0;
        this.panel.add((Component)this.warningLabel, gbcWarningLabel);
        JLabel lblTargetBalance = new JLabel(LocalizationData.get("CheckModePanel.target"));
        GridBagConstraints gbcLblTargetBalance = new GridBagConstraints();
        gbcLblTargetBalance.weightx = 1.0;
        gbcLblTargetBalance.anchor = 13;
        gbcLblTargetBalance.insets = new Insets(0, 5, 0, 5);
        gbcLblTargetBalance.gridx = 3;
        gbcLblTargetBalance.gridy = 0;
        this.panel.add((Component)lblTargetBalance, gbcLblTargetBalance);
        this.targetAmount = new CurrencyWidget();
        this.targetAmount.setColumns(8);
        this.targetAmount.setToolTipText(LocalizationData.get("CheckModePanel.target.tooltip"));
        GridBagConstraints gbcTargetAmount = new GridBagConstraints();
        gbcTargetAmount.anchor = 13;
        gbcTargetAmount.insets = new Insets(0, 0, 0, 5);
        gbcTargetAmount.fill = 2;
        gbcTargetAmount.gridx = 4;
        gbcTargetAmount.gridy = 0;
        this.panel.add((Component)this.targetAmount, gbcTargetAmount);
        this.targetAmount.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BalancePanel.this.updateBalances();
            }
        });
        this.add((Component)this.startBalance, gridBagConstraints4);
        this.add((Component)this.endBalance, gridBagConstraints6);
        this.gapLabel = new JLabel();
        this.gapLabel.setForeground(Color.RED);
        GridBagConstraints gbcGapLabel = new GridBagConstraints();
        gbcGapLabel.insets = new Insets(0, 0, 0, 5);
        gbcGapLabel.anchor = 13;
        gbcGapLabel.gridx = 2;
        gbcGapLabel.gridy = 1;
        this.add((Component)this.gapLabel, gbcGapLabel);
    }

    private void setStart(String text) {
        this.startBalance.setText(text);
    }

    private void setEnd(String text) {
        this.endBalance.setText(text);
    }

    public void setCheckMode(boolean checkMode) {
        this.panel.setVisible(checkMode);
        if (!checkMode) {
            this.targetAmount.setValue(null);
        }
    }

    public void setAlertVisible(boolean visible) {
        this.warningLabel.setVisible(visible);
    }

    private JLabel getLabelStatement() {
        if (this.labelStatement == null) {
            this.labelStatement = new JLabel(LocalizationData.get("TransactionDialog.statement"));
            this.labelStatement.setForeground(Color.RED);
            this.labelStatement.setFont(this.bigFont);
        }
        return this.labelStatement;
    }

    public String getEditedStatement() {
        this.editedStatement = this.statementField.getText().trim();
        if (this.editedStatement.isEmpty()) {
            this.editedStatement = null;
        }
        return this.editedStatement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
        this.updateBalances();
    }

    private void updateBalances() {
        DecimalFormat ci = LocalizationData.getCurrencyInstance();
        this.setStart(Formatter.format(LocalizationData.get("StatementView.startBalance"), this.statement != null ? ci.format(this.statement.getStartBalance()) : ""));
        this.setEnd(Formatter.format(LocalizationData.get("StatementView.endBalance"), this.statement != null ? ci.format(this.statement.getEndBalance()) : ""));
        Double target = this.targetAmount.getValue();
        if (this.statement == null || target == null || GlobalData.AMOUNT_COMPARATOR.compare(target, this.statement.getEndBalance()) == 0) {
            this.gapLabel.setVisible(false);
        } else {
            this.gapLabel.setText(Formatter.format(LocalizationData.get("CheckModePanel.gap"), ci.format(target - this.statement.getEndBalance())));
            this.gapLabel.setVisible(true);
        }
    }
}

