/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.statementview;

import com.fathzer.soft.ajlib.swing.widget.date.DateWidget;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.yapbam.data.Transaction;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.statementview.StatementTable;
import net.yapbam.gui.statementview.TransactionsUpdater;
import net.yapbam.gui.widget.AutoSelectFocusListener;

public class ChangeValueDatePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton valueDateLabel;
    private DateWidget valueDate;
    private StatementTable table;
    private TransactionsUpdater updater = new TransactionsUpdater(){

        @Override
        protected Transaction update(Transaction t) {
            return new Transaction(t.getDate(), t.getNumber(), t.getDescription(), t.getComment(), t.getAmount(), t.getAccount(), t.getMode(), t.getCategory(), ChangeValueDatePanel.this.valueDate.getDate(), t.getStatement(), Arrays.asList(t.getSubTransactions()));
        }
    };

    public ChangeValueDatePanel(StatementTable transactionTable) {
        this.table = transactionTable;
        this.setLayout(new GridBagLayout());
        this.valueDateLabel = new JButton(LocalizationData.get("CheckModePanel.valueDateEnabled"));
        this.valueDateLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangeValueDatePanel.this.table.setSelectedTransactions(ChangeValueDatePanel.this.updater.update(ChangeValueDatePanel.this.table));
            }
        });
        GridBagConstraints gbcValueDateLabel = new GridBagConstraints();
        gbcValueDateLabel.anchor = 17;
        gbcValueDateLabel.insets = new Insets(0, 0, 0, 5);
        gbcValueDateLabel.gridx = 0;
        gbcValueDateLabel.gridy = 0;
        this.add((Component)this.valueDateLabel, gbcValueDateLabel);
        this.valueDateLabel.setToolTipText(LocalizationData.get("CheckModePanel.valueDateEnabled.toolTip"));
        this.valueDate = new DateWidget();
        this.valueDate.getDateField().setMinimumSize(this.valueDate.getDateField().getPreferredSize());
        GridBagConstraints gbcValueDate = new GridBagConstraints();
        gbcValueDate.gridx = 1;
        gbcValueDate.gridy = 0;
        this.add((Component)this.valueDate, gbcValueDate);
        this.valueDate.setDate(null);
        this.valueDate.setLocale(LocalizationData.getLocale());
        this.valueDate.setToolTipText(LocalizationData.get("CheckModePanel.valueDate.tooltip"));
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ChangeValueDatePanel.this.refreshOk();
            }
        };
        if (transactionTable != null) {
            transactionTable.addPropertyChangeListener("selectedTransaction", listener);
        }
        this.valueDate.addPropertyChangeListener("date", listener);
        this.valueDate.getDateField().addFocusListener(AutoSelectFocusListener.INSTANCE);
        this.refreshOk();
    }

    private void refreshOk() {
        boolean ok = this.valueDate.getDate() != null;
        ok = ok && this.table != null && this.table.getSelectedTransactions().length > 0;
        this.valueDateLabel.setEnabled(ok);
    }

    public Date getValueDate() {
        return this.valueDate.getDate();
    }
}

