/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.statementview;

import java.awt.Toolkit;
import java.awt.print.Printable;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.yapbam.data.Account;
import net.yapbam.data.FilteredData;
import net.yapbam.gui.AbstractPlugIn;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.TransactionSelector;
import net.yapbam.gui.YapbamState;
import net.yapbam.gui.statementview.DualTransactionSelector;
import net.yapbam.gui.statementview.StatementViewPanel;

public class StatementViewPlugin
extends AbstractPlugIn {
    private static final String STATE_PREFIX = "net.yapbam.statementView.";
    private static final String UNCHECKED_PREFIX = "net.yapbam.statementView.unchecked.";
    private StatementViewPanel panel;

    public StatementViewPlugin(FilteredData data, Object state) {
        this.panel = new StatementViewPanel(data);
        this.setPanelTitle(LocalizationData.get("StatementView.title"));
        this.setPanelToolTip(LocalizationData.get("StatementView.tooltip"));
        this.setPrintingSupported(true);
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void restoreState() {
        YapbamState.INSTANCE.restoreState(this.panel.getTransactionsTable(), STATE_PREFIX);
        YapbamState.INSTANCE.restoreState(this.panel.getUncheckedTransactionsTable(), UNCHECKED_PREFIX);
    }

    @Override
    public void saveState() {
        YapbamState.INSTANCE.saveState(this.panel.getTransactionsTable(), STATE_PREFIX);
        YapbamState.INSTANCE.saveState(this.panel.getUncheckedTransactionsTable(), UNCHECKED_PREFIX);
    }

    @Override
    public boolean allowMenu(int menuId) {
        if (menuId == 2) {
            return false;
        }
        return super.allowMenu(menuId);
    }

    @Override
    protected Printable getPrintable() {
        return this.panel.getPrintable();
    }

    @Override
    public TransactionSelector getTransactionSelector() {
        return new DualTransactionSelector(this.panel);
    }

    @Override
    public JMenuItem[] getMenuItem(int part) {
        if (part == 4) {
            JMenuItem item = new JMenuItem(this.panel.checkAction);
            item.setAccelerator(KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            return new JMenuItem[]{null, item};
        }
        return super.getMenuItem(part);
    }

    @Override
    public void setDisplayed(boolean displayed) {
        super.setDisplayed(displayed);
        if (displayed) {
            this.panel.checkAction.updateEnabled();
        } else {
            this.panel.checkAction.setEnabled(false);
        }
    }

    @Override
    public Account getSelectedAccount() {
        return this.panel.getSelectedAccount();
    }
}

