/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.statistics;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.yapbam.data.Category;
import net.yapbam.data.GlobalData;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.statistics.OptimizedToolTipGenerator;
import net.yapbam.gui.statistics.Summary;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.SortOrder;

class PieChartPanel
extends ChartPanel {
    private DefaultPieDataset dataset;
    private Map<Category, Summary> categoryToAmount;
    private OptimizedToolTipGenerator toolTipGenerator;

    PieChartPanel(Map<Category, Summary> map) {
        super((JFreeChart)null);
        super.setLocale(LocalizationData.getLocale());
        super.setPopupMenu(this.createPopupMenu(true, false, false, true, false));
        this.categoryToAmount = map;
        this.dataset = new DefaultPieDataset();
        this.toolTipGenerator = new OptimizedToolTipGenerator();
        this.updateDataSet();
        JFreeChart chart = ChartFactory.createPieChart(LocalizationData.get("StatisticsPlugin.pie.byCategory.title"), (PieDataset)this.dataset, false, true, false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setToolTipGenerator(this.toolTipGenerator);
        plot.setSectionOutlinesVisible(true);
        plot.setNoDataMessage(LocalizationData.get("StatisticsPlugin.pie.byCategory.empty"));
        this.setChart(chart);
    }

    void updateDataSet() {
        this.dataset.clear();
        double total = 0.0;
        Iterator<Category> it = this.categoryToAmount.keySet().iterator();
        HashMap<String, Double> map = new HashMap<String, Double>();
        while (it.hasNext()) {
            Category category = it.next();
            Summary summary = this.categoryToAmount.get(category);
            double expense = -summary.getReceipts() - summary.getDebts();
            if (GlobalData.AMOUNT_COMPARATOR.compare(expense, 0.0) <= 0) continue;
            total += expense;
            map.put(category.equals(Category.UNDEFINED) ? LocalizationData.get("Category.undefined") : category.getName(), expense);
        }
        for (Map.Entry entry : map.entrySet()) {
            this.dataset.setValue((Comparable)entry.getKey(), (Number)entry.getValue());
        }
        this.dataset.sortByKeys(SortOrder.ASCENDING);
        this.toolTipGenerator.clear();
    }
}

